/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.android.future.usb.UsbAccessory;
import com.android.future.usb.UsbManager;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ADKCommunication
implements Runnable {
    private static final String ACTION_USB_PERMISSION = "com.google.android.DemoKit.action.USB_PERMISSION";
    private UsbManager mUsbManager;
    private PendingIntent mPermissionIntent;
    private boolean mPermissionRequestPending;
    private UsbAccessory mAccessory;
    private ParcelFileDescriptor mFileDescriptor;
    private FileInputStream mInputStream;
    private FileOutputStream mOutputStream;
    private byte[] rawbuffer;
    private int bytes = 0;
    private byte[] buffer;
    private Context context;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UsbAccessory usbAccessory;
            String string = intent.getAction();
            if (ADKCommunication.ACTION_USB_PERMISSION.equals(string)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbAccessory usbAccessory2 = UsbManager.getAccessory((Intent)intent);
                    if (intent.getBooleanExtra("permission", false)) {
                        Log.i((String)"System.out", (String)("Opening " + usbAccessory2.getDescription()));
                        ADKCommunication.this.openAccessory(usbAccessory2);
                    } else {
                        Log.i((String)"System.out", (String)("Permission denied for " + usbAccessory2.getDescription()));
                    }
                    ADKCommunication.this.mPermissionRequestPending = false;
                }
            } else if ("android.hardware.usb.action.USB_ACCESSORY_DETACHED".equals(string) && (usbAccessory = UsbManager.getAccessory((Intent)intent)) != null && usbAccessory.equals((Object)ADKCommunication.this.mAccessory)) {
                ADKCommunication.this.closeAccessory();
            }
        }
    };

    public ADKCommunication(Context context) {
        this.context = context;
        this.mUsbManager = UsbManager.getInstance((Context)context);
    }

    public byte[] getRawBuffer() {
        return this.rawbuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(UsbAccessory usbAccessory) {
        if (usbAccessory == null) {
            Log.i((String)"System.out", (String)"Accessory was null, had to quit the connect attempt");
            return;
        }
        Log.i((String)"System.out", (String)("Trying to connect to accessory " + usbAccessory.getDescription()));
        if (this.mInputStream != null && this.mOutputStream != null) {
            Log.i((String)"System.out", (String)"Streams already made... let's not do it again. ");
            return;
        }
        if (this.mUsbManager == null) {
            this.mUsbManager = UsbManager.getInstance((Context)this.context);
            Log.i((String)"System.out", (String)("UsbManager was null, tried to make it again (" + (this.mUsbManager != null ? "success" : "fail")));
        }
        if (this.mUsbManager.hasPermission(usbAccessory)) {
            Log.i((String)"System.out", (String)"Trying to open the accessory");
            this.openAccessory(usbAccessory);
        } else {
            BroadcastReceiver broadcastReceiver = this.mUsbReceiver;
            synchronized (broadcastReceiver) {
                if (!this.mPermissionRequestPending) {
                    this.mUsbManager.requestPermission(usbAccessory, this.mPermissionIntent);
                    this.mPermissionRequestPending = true;
                }
            }
        }
    }

    public boolean isConnected() {
        return this.mAccessory != null;
    }

    public void write(byte by) throws IOException {
        if (this.mOutputStream != null) {
            this.mOutputStream.write(by);
        }
    }

    public UsbAccessory[] getAccessories() {
        UsbAccessory[] usbAccessoryArray;
        if (this.mUsbManager == null) {
            this.mUsbManager = UsbManager.getInstance((Context)this.context);
        }
        if ((usbAccessoryArray = this.mUsbManager.getAccessoryList()) == null) {
            return null;
        }
        return usbAccessoryArray;
    }

    private void openAccessory(UsbAccessory usbAccessory) {
        this.mFileDescriptor = this.mUsbManager.openAccessory(usbAccessory);
        Log.i((String)"test", (String)("mFileDescriptor? " + (this.mFileDescriptor != null ? "ok!" : "not ok!")));
        if (this.mFileDescriptor != null) {
            this.mAccessory = usbAccessory;
            FileDescriptor fileDescriptor = this.mFileDescriptor.getFileDescriptor();
            this.mInputStream = new FileInputStream(fileDescriptor);
            this.mOutputStream = new FileOutputStream(fileDescriptor);
            Thread thread = new Thread(null, this, "AndroidAdkUsb");
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAccessory() {
        try {
            if (this.mFileDescriptor != null) {
                this.mFileDescriptor.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.mFileDescriptor = null;
            this.mAccessory = null;
        }
    }

    public int available() {
        return this.bytes;
    }

    @Override
    public void run() {
        this.rawbuffer = new byte[128];
        this.buffer = new byte[128];
        while (this.bytes >= 0) {
            try {
                this.bytes = this.mInputStream.read(this.rawbuffer);
                this.buffer = (byte[])this.rawbuffer.clone();
            }
            catch (IOException iOException) {
                this.bytes = 0;
                break;
            }
        }
    }

    public byte readByte() {
        byte by = this.buffer[0];
        if (this.bytes > 0) {
            System.arraycopy(this.buffer, 1, this.buffer, 0, this.buffer.length - 1);
            --this.bytes;
        } else {
            this.buffer = (byte[])this.rawbuffer.clone();
        }
        return (byte)(by & 0xFF);
    }
}

