/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.adk.processing;

import cc.arduino.adk.processing.MyBuild;
import cc.arduino.adk.processing.MyDevice;
import cc.arduino.adk.processing.MyDeviceListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.Editor;
import processing.app.RunnerListener;
import processing.app.SketchException;
import processing.mode.java.runner.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyRunner
implements MyDeviceListener {
    MyBuild build;
    RunnerListener listener;
    private volatile MyDevice lastRunDevice = null;
    private static final Pattern LOCATION = Pattern.compile("\\(([^:]+):(\\d+)\\)");
    private static final Pattern EXCEPTION_PARSER = Pattern.compile("^\\s*([a-z]+(?:\\.[a-z]+)+)(?:: .+)?$", 2);

    public MyRunner(MyBuild myBuild, RunnerListener runnerListener) {
        this.build = myBuild;
        this.listener = runnerListener;
    }

    public MyRunner(MyBuild myBuild, Editor editor) {
        this.build = myBuild;
        this.listener = editor;
    }

    public void launch(Future<MyDevice> future) {
        this.listener.statusNotice("Waiting for device to become available...");
        System.out.println("Waiting for device to become available...");
        MyDevice myDevice = this.waitForDevice(future, this.listener);
        if (myDevice == null || !myDevice.isAlive()) {
            this.listener.statusError("Device killed or disconnected.");
            System.out.println("Device killed or disconnected.");
            return;
        }
        myDevice.addListener(this);
        this.listener.statusNotice("Installing sketch on " + myDevice.getId());
        System.out.println("Installing sketch on " + myDevice.getId());
        if (!myDevice.installApp(this.build.getPathForAPK(), this.listener)) {
            this.listener.statusError("Device killed or disconnected.");
            System.out.println("Device killed or disconnected.");
            return;
        }
        this.listener.statusNotice("Starting sketch on " + myDevice.getId());
        System.out.println("Starting sketch on " + myDevice.getId());
        if (this.startSketch(this.build, myDevice)) {
            this.listener.statusNotice("Sketch launched on the " + (myDevice.isEmulator() ? "emulator" : "phone") + ".");
        } else {
            this.listener.statusError("Could not start the sketch.");
            System.out.println("Could not start the sketch.");
        }
        this.lastRunDevice = myDevice;
    }

    private boolean startSketch(MyBuild myBuild, MyDevice myDevice) {
        String string = myBuild.getPackageName();
        String string2 = myBuild.getSketchClassName();
        try {
            if (myDevice.launchApp(string, string2)) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return false;
    }

    private MyDevice waitForDevice(Future<MyDevice> future, RunnerListener runnerListener) {
        for (int i = 0; i < 120; ++i) {
            if (runnerListener.isHalted()) {
                future.cancel(true);
                return null;
            }
            try {
                return future.get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                runnerListener.statusError("Interrupted.");
                return null;
            }
            catch (ExecutionException executionException) {
                runnerListener.statusError((Exception)executionException);
                return null;
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
        }
        runnerListener.statusError("No, on second thought, I'm giving up on waiting for that device to show up.");
        return null;
    }

    @Override
    public void stackTrace(List<String> list) {
        Iterator<String> iterator = list.iterator();
        String string = iterator.next();
        Matcher matcher = EXCEPTION_PARSER.matcher(string);
        if (!matcher.matches()) {
            System.err.println("Can't parse this exception line:");
            System.err.println(string);
            this.listener.statusError("Unknown exception");
            return;
        }
        String string2 = matcher.group(1);
        if (Runner.handleCommonErrors((String)string2, (String)string, (RunnerListener)this.listener)) {
            return;
        }
        while (iterator.hasNext()) {
            int n;
            Matcher matcher2;
            String string3 = iterator.next();
            if (!string3.contains("processing.android") || !(matcher2 = LOCATION.matcher(string3)).find()) continue;
            String string4 = matcher2.group(1);
            SketchException sketchException = this.build.placeException(string, string4, n = Integer.parseInt(matcher2.group(2)) - 1);
            this.listener.statusError((Exception)((Object)(sketchException == null ? new SketchException(string, false) : sketchException)));
            return;
        }
    }

    public void close() {
        if (this.lastRunDevice != null) {
            this.lastRunDevice.bringLauncherToFront();
        }
    }

    @Override
    public void sketchStopped() {
        this.listener.stopIndeterminate();
        this.listener.statusHalt();
    }
}

