/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.adk.processing;

import cc.arduino.adk.processing.MyAVD;
import cc.arduino.adk.processing.MyDevices;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.exec.LineProcessor;
import processing.app.exec.ProcessRegistry;
import processing.app.exec.StreamPump;
import processing.core.PApplet;

class MyEmulatorController {
    private static final MyEmulatorController INSTANCE = new MyEmulatorController();
    private volatile State state = State.NOT_RUNNING;

    MyEmulatorController() {
    }

    public static MyEmulatorController getInstance() {
        return INSTANCE;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        if (Base.DEBUG) {
            System.out.println("Emulator state: " + (Object)((Object)state));
            new Exception().printStackTrace(System.out);
        }
        this.state = state;
    }

    public synchronized void launch() throws IOException {
        if (this.state != State.NOT_RUNNING) {
            String string = "You can't launch an emulator whose state is " + (Object)((Object)this.state);
            throw new IllegalStateException(string);
        }
        String string = Preferences.get((String)"android.emulator.port");
        if (string == null) {
            string = "5566";
            Preferences.set((String)"android.emulator.port", (String)string);
        }
        String[] stringArray = new String[]{"emulator", "-avd", MyAVD.defaultAVD.name, "-port", string, "-no-boot-anim"};
        final Process process = Runtime.getRuntime().exec(stringArray);
        ProcessRegistry.watch((Process)process);
        new StreamPump(process.getInputStream(), "emulator: ").addTarget((OutputStream)System.out).start();
        this.setState(State.WAITING_FOR_BOOT);
        final String string2 = PApplet.join((String[])stringArray, (char)' ');
        StreamPump streamPump = new StreamPump(process.getInputStream(), "out: " + string2);
        streamPump.addTarget(new LineProcessor(){

            public void processLine(String string) {
                if (!string.contains("the cache image is used by another emulator")) {
                    System.out.println(string2 + ": " + string);
                }
            }
        });
        StreamPump streamPump2 = new StreamPump(process.getErrorStream(), "err: " + string2);
        streamPump2.addTarget(new LineProcessor(){

            public void processLine(String string) {
                if (!string.contains("This application, or a library it uses, is using NSQuickDrawView")) {
                    System.err.println(string2 + ": " + string);
                }
            }
        });
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block6: while (true) {
                    String string;
                    Iterator<String> iterator;
                    try {
                        if (MyEmulatorController.this.state == State.WAITING_FOR_BOOT) {
                            if (Base.DEBUG) {
                                System.out.println("sleeping for 2 seconds " + new Date().toString());
                            }
                        } else {
                            System.err.println("EmulatorController: Emulator never booted. " + (Object)((Object)MyEmulatorController.this.state));
                            return;
                        }
                        Thread.sleep(2000L);
                        iterator = MyDevices.list().iterator();
                    }
                    catch (Exception exception) {
                        System.err.println("While waiting for emulator to boot " + exception);
                        process.destroy();
                        return;
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                    do {
                        if (!iterator.hasNext()) continue block6;
                    } while (!(string = iterator.next()).contains("emulator"));
                    break;
                }
                MyEmulatorController.this.setState(State.RUNNING);
            }
        }, "EmulatorController: Wait for emulator to boot").start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println("Emulator was interrupted.");
                    }
                    finally {
                        process.destroy();
                        ProcessRegistry.unwatch((Process)process);
                    }
                }
                finally {
                    MyEmulatorController.this.setState(State.NOT_RUNNING);
                }
            }
        }, "EmulatorController: Process manager").start();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interrupted while waiting for emulator to launch.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_RUNNING,
        WAITING_FOR_BOOT,
        RUNNING;

    }
}

