/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.adk.processing;

import cc.arduino.adk.processing.MyAndroidSDK;
import cc.arduino.adk.processing.MyDevice;
import cc.arduino.adk.processing.MyEmulatorController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import processing.app.Base;
import processing.app.exec.ProcessResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MyDevices {
    private static final String ADB_DEVICES_ERROR = "Received unfamiliar output from \u201cadb devices\u201d.\nThe device list may have errors.";
    private static final MyDevices INSTANCE = new MyDevices();
    private final Map<String, MyDevice> devices = new ConcurrentHashMap<String, MyDevice>();
    private final ExecutorService deviceLaunchThread = Executors.newSingleThreadExecutor();

    public static MyDevices getInstance() {
        return INSTANCE;
    }

    public static void killAdbServer() {
        System.out.println("Shutting down any existing adb server...");
        System.out.flush();
        try {
            MyAndroidSDK.runADB("kill-server");
        }
        catch (Exception exception) {
            System.err.println("failed.");
            System.err.println();
            exception.printStackTrace(System.err);
        }
    }

    private MyDevices() {
        if (Base.DEBUG) {
            System.out.println("Starting up Devices");
        }
        Runtime.getRuntime().addShutdownHook(new Thread("AndroidEnvironment Shutdown"){

            public void run() {
                MyDevices.this.shutdown();
            }
        });
    }

    private void shutdown() {
        for (MyDevice myDevice : new ArrayList<MyDevice>(this.devices.values())) {
            myDevice.shutdown();
        }
    }

    public Future<MyDevice> getEmulator() {
        Callable<MyDevice> callable = new Callable<MyDevice>(){

            @Override
            public MyDevice call() throws Exception {
                return MyDevices.this.blockingGetEmulator();
            }
        };
        FutureTask<MyDevice> futureTask = new FutureTask<MyDevice>(callable);
        this.deviceLaunchThread.execute(futureTask);
        return futureTask;
    }

    private final MyDevice blockingGetEmulator() {
        MyDevice myDevice = this.find(true);
        if (myDevice != null) {
            return myDevice;
        }
        MyEmulatorController myEmulatorController = MyEmulatorController.getInstance();
        if (myEmulatorController.getState() == MyEmulatorController.State.NOT_RUNNING) {
            try {
                myEmulatorController.launch();
            }
            catch (IOException iOException) {
                System.err.println("Problem while launching emulator.");
                iOException.printStackTrace(System.err);
                return null;
            }
        } else {
            System.out.println("Emulator is " + (Object)((Object)myEmulatorController.getState()) + ", which is not expected.");
        }
        while (!Thread.currentThread().isInterrupted()) {
            if (myEmulatorController.getState() == MyEmulatorController.State.NOT_RUNNING) {
                System.err.println("Ouch. Emulator got killed, I think.");
                return null;
            }
            myDevice = this.find(true);
            if (myDevice != null) {
                return myDevice;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Devices: interrupted in loop.");
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MyDevice find(boolean bl) {
        this.refresh();
        Map<String, MyDevice> map = this.devices;
        synchronized (map) {
            for (MyDevice myDevice : this.devices.values()) {
                boolean bl2 = myDevice.getId().contains("emulator");
                if ((!bl2 || !bl) && (bl2 || bl)) continue;
                return myDevice;
            }
        }
        return null;
    }

    public Future<MyDevice> getHardware() {
        Callable<MyDevice> callable = new Callable<MyDevice>(){

            @Override
            public MyDevice call() throws Exception {
                return MyDevices.this.blockingGetHardware();
            }
        };
        FutureTask<MyDevice> futureTask = new FutureTask<MyDevice>(callable);
        this.deviceLaunchThread.execute(futureTask);
        return futureTask;
    }

    private final MyDevice blockingGetHardware() {
        MyDevice myDevice = this.find(false);
        if (myDevice != null) {
            return myDevice;
        }
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            myDevice = this.find(false);
            if (myDevice == null) continue;
            return myDevice;
        }
        return null;
    }

    private void refresh() {
        List<String> list = MyDevices.list();
        for (String string : list) {
            if (this.devices.containsKey(string)) continue;
            this.addDevice(new MyDevice(this, string));
        }
    }

    private void addDevice(MyDevice myDevice) {
        try {
            myDevice.initialize();
            if (this.devices.put(myDevice.getId(), myDevice) != null) {
                throw new IllegalStateException("Adding " + myDevice + ", which already exists!");
            }
        }
        catch (Exception exception) {
            System.err.println("While initializing " + myDevice.getId() + ": " + exception);
        }
    }

    void deviceRemoved(MyDevice myDevice) {
        if (this.devices.remove(myDevice.getId()) == null) {
            throw new IllegalStateException("I didn't know about device " + myDevice.getId() + "!");
        }
    }

    public static List<String> list() {
        ProcessResult processResult;
        try {
            processResult = MyAndroidSDK.runADB("devices");
        }
        catch (InterruptedException interruptedException) {
            return Collections.emptyList();
        }
        catch (IOException iOException) {
            System.err.println("Problem inside Devices.list()");
            iOException.printStackTrace();
            return Collections.emptyList();
        }
        if (!processResult.succeeded()) {
            if (processResult.getStderr().contains("protocol fault (no status)")) {
                System.err.println("bleh: " + processResult);
            } else {
                System.err.println("nope: " + processResult);
            }
            return Collections.emptyList();
        }
        String string = processResult.getStdout();
        if (!string.startsWith("List of devices") && string.trim().length() != 0) {
            System.err.println(ADB_DEVICES_ERROR);
            System.err.println("Output was \u201c" + string + "\u201d");
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : processResult) {
            String[] stringArray;
            if (!string2.contains("\t") || !(stringArray = string2.split("\t"))[1].equals("device")) continue;
            arrayList.add(stringArray[0]);
        }
        return arrayList;
    }
}

