/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.adk.processing;

import cc.arduino.adk.processing.MyAndroidSDK;
import cc.arduino.adk.processing.MyDeviceListener;
import cc.arduino.adk.processing.MyDeviceProperties;
import cc.arduino.adk.processing.MyDevices;
import cc.arduino.adk.processing.MyLogEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.RunnerListener;
import processing.app.exec.LineProcessor;
import processing.app.exec.ProcessRegistry;
import processing.app.exec.ProcessResult;
import processing.app.exec.StreamPump;
import processing.core.PApplet;

class MyDevice
implements MyDeviceProperties {
    private final MyDevices env;
    private final String id;
    private final Set<Integer> activeProcesses = new HashSet<Integer>();
    private final Set<MyDeviceListener> listeners = Collections.synchronizedSet(new HashSet());
    private Process logcat;
    private static final Pattern SIG = Pattern.compile("PID:\\s+(\\d+)\\s+SIG:\\s+(\\d+)");
    private final List<String> stackTrace = new ArrayList<String>();

    public MyDevice(MyDevices myDevices, String string) {
        this.env = myDevices;
        this.id = string;
    }

    public void bringLauncherToFront() {
        try {
            this.adb("shell", "am", "start", "-a", "android.intent.action.MAIN", "-c", "android.intent.category.HOME");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public boolean installApp(String string, RunnerListener runnerListener) {
        if (!this.isAlive()) {
            return false;
        }
        this.bringLauncherToFront();
        try {
            ProcessResult processResult = this.adb("install", "-r", string);
            if (!processResult.succeeded()) {
                runnerListener.statusError("Could not install the sketch.");
                System.err.println(processResult);
                return false;
            }
            String string2 = null;
            for (String string3 : processResult) {
                if (!string3.startsWith("Failure")) continue;
                string2 = string3.substring(8);
                System.err.println(string3);
            }
            if (string2 == null) {
                runnerListener.statusNotice("Done installing.");
                return true;
            }
            runnerListener.statusError("Error while installing " + string2);
        }
        catch (IOException iOException) {
            runnerListener.statusError((Exception)iOException);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public boolean installApp(String string) {
        if (!this.isAlive()) {
            return false;
        }
        this.bringLauncherToFront();
        try {
            ProcessResult processResult = this.adb("install", "-r", string);
            if (!processResult.succeeded()) {
                System.out.println("Could not install the sketch.");
                System.err.println(processResult);
                return false;
            }
            String string2 = null;
            for (String string3 : processResult) {
                if (!string3.startsWith("Failure")) continue;
                string2 = string3.substring(8);
                System.err.println(string3);
            }
            if (string2 == null) {
                System.out.println("Done installing.");
                return true;
            }
            System.out.println("Error while installing " + string2);
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public boolean launchApp(String string, String string2) throws IOException, InterruptedException {
        if (!this.isAlive()) {
            return false;
        }
        return this.adb("shell", "am", "start", "-e", "debug", "true", "-a", "android.intent.action.MAIN", "-c", "android.intent.category.LAUNCHER", "-n", string + "/." + string2).succeeded();
    }

    public boolean isEmulator() {
        return this.id.startsWith("emulator");
    }

    private void reportStackTrace(MyLogEntry myLogEntry) {
        if (this.stackTrace.isEmpty()) {
            System.err.println("That's weird. Proc " + myLogEntry.pid + " got signal 3, but there's no stack trace.");
        }
        List<String> list = Collections.unmodifiableList(new ArrayList<String>(this.stackTrace));
        for (MyDeviceListener myDeviceListener : this.listeners) {
            myDeviceListener.stackTrace(list);
        }
        this.stackTrace.clear();
    }

    void initialize() throws IOException, InterruptedException {
        this.adb("logcat", "-c");
        String[] stringArray = this.generateAdbCommand("logcat");
        String string = PApplet.join((String[])stringArray, (char)' ');
        this.logcat = Runtime.getRuntime().exec(stringArray);
        ProcessRegistry.watch((Process)this.logcat);
        new StreamPump(this.logcat.getInputStream(), "log: " + string).addTarget((LineProcessor)new LogLineProcessor()).start();
        new StreamPump(this.logcat.getErrorStream(), "err: " + string).addTarget((OutputStream)System.err).start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MyDevice.this.logcat.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("AndroidDevice: logcat process monitor interrupted");
                }
                finally {
                    MyDevice.this.shutdown();
                }
            }
        }, "AndroidDevice: logcat process monitor").start();
    }

    synchronized void shutdown() {
        if (!this.isAlive()) {
            return;
        }
        if (this.logcat != null) {
            this.logcat.destroy();
            this.logcat = null;
            ProcessRegistry.unwatch((Process)this.logcat);
        }
        this.env.deviceRemoved(this);
        if (this.activeProcesses.size() > 0) {
            for (MyDeviceListener myDeviceListener : this.listeners) {
                myDeviceListener.sketchStopped();
            }
        }
        this.listeners.clear();
    }

    synchronized boolean isAlive() {
        return this.logcat != null;
    }

    public String getId() {
        return this.id;
    }

    public MyDevices getEnv() {
        return this.env;
    }

    private void startProc(String string, int n) {
        this.activeProcesses.add(n);
    }

    private void endProc(int n) {
        this.activeProcesses.remove(n);
        for (MyDeviceListener myDeviceListener : this.listeners) {
            myDeviceListener.sketchStopped();
        }
    }

    public void addListener(MyDeviceListener myDeviceListener) {
        this.listeners.add(myDeviceListener);
    }

    public void removeListener(MyDeviceListener myDeviceListener) {
        this.listeners.remove(myDeviceListener);
    }

    private ProcessResult adb(String ... stringArray) throws InterruptedException, IOException {
        String[] stringArray2 = this.generateAdbCommand(stringArray);
        return MyAndroidSDK.runADB(stringArray2);
    }

    private String[] generateAdbCommand(String ... stringArray) {
        return PApplet.concat((String[])new String[]{"adb", "-s", this.getId()}, (String[])stringArray);
    }

    public String toString() {
        return "[AndroidDevice " + this.getId() + "]";
    }

    private class LogLineProcessor
    implements LineProcessor {
        private LogLineProcessor() {
        }

        public void processLine(String string) {
            MyLogEntry myLogEntry = new MyLogEntry(string);
            if (myLogEntry.message.startsWith("PROCESSING")) {
                if (myLogEntry.message.contains("onStart")) {
                    MyDevice.this.startProc(myLogEntry.source, myLogEntry.pid);
                } else if (myLogEntry.message.contains("onStop")) {
                    MyDevice.this.endProc(myLogEntry.pid);
                }
            } else if (myLogEntry.source.equals("Process")) {
                this.handleCrash(myLogEntry);
            } else if (MyDevice.this.activeProcesses.contains(myLogEntry.pid)) {
                this.handleConsole(myLogEntry);
            }
        }

        private void handleCrash(MyLogEntry myLogEntry) {
            Matcher matcher = SIG.matcher(myLogEntry.message);
            if (matcher.find()) {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                if (MyDevice.this.activeProcesses.contains(n) && n2 == 3) {
                    MyDevice.this.endProc(n);
                    MyDevice.this.reportStackTrace(myLogEntry);
                }
            }
        }

        private void handleConsole(MyLogEntry myLogEntry) {
            boolean bl;
            boolean bl2 = bl = myLogEntry.source.equals("AndroidRuntime") && myLogEntry.severity == MyLogEntry.Severity.Error;
            if (bl) {
                if (!myLogEntry.message.startsWith("Uncaught handler")) {
                    MyDevice.this.stackTrace.add(myLogEntry.message);
                    System.err.println(myLogEntry.message);
                }
            } else if (myLogEntry.source.equals("System.out") || myLogEntry.source.equals("System.err")) {
                if (myLogEntry.severity.useErrorStream) {
                    System.err.println(myLogEntry.message);
                } else {
                    System.out.println(myLogEntry.message);
                }
            }
        }
    }
}

