/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.adk.processing;

import cc.arduino.adk.processing.MyBadSDKException;
import cc.arduino.adk.processing.MyBuild;
import cc.arduino.adk.processing.MyDevices;
import cc.arduino.adk.processing.MyRunner;
import java.io.IOException;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.mode.android.AndroidMode;
import processing.mode.java.JavaMode;

class MyCompileThread
extends Thread {
    Editor editor;
    MyBuild build;
    MyRunner runner;

    public MyCompileThread(Editor editor) {
        this.editor = editor;
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        this.compileAndUpload();
    }

    public void compileAndUpload() {
        this.editor.statusNotice("compile and upload");
        Sketch sketch = this.editor.getSketch();
        if (this.editor.getMode().getClass() == JavaMode.class) {
            Base.showError((String)"Error", (String)"This tool can only be used in Android mode.", null);
            return;
        }
        try {
            this.build = new MyBuild(sketch, (AndroidMode)this.editor.getMode());
            try {
                this.build.build("debug");
                this.runner = new MyRunner(this.build, this.editor);
                this.runner.launch(MyDevices.getInstance().getHardware());
            }
            catch (SketchException sketchException) {
                sketchException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException");
        }
        catch (MyBadSDKException myBadSDKException) {
            System.out.println("MyBadSDKException");
        }
    }
}

