/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.adk.processing;

import cc.arduino.adk.processing.MyAndroidSDK;
import cc.arduino.adk.processing.MyBadSDKException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import processing.app.Base;
import processing.app.Library;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.core.PApplet;
import processing.core.XML;
import processing.mode.android.AndroidMode;
import processing.mode.android.AndroidPreprocessor;
import processing.mode.android.Manifest;
import processing.mode.java.JavaBuild;
import processing.mode.java.preproc.PdePreprocessor;

class MyBuild
extends JavaBuild {
    static final String basePackage = "processing.android.test";
    static final String sdkVersion = "10";
    static final String sdkTarget = "Google Inc.:Google APIs:10";
    private final MyAndroidSDK sdk = MyBuild.getSDK();
    private final File coreZipFile;
    private File coreZipLocation;
    private String target;
    private Manifest manifest;
    private File tmpFolder;
    private File buildFile;
    static final String MANIFEST_XML = "AndroidManifest.xml";
    static final String ACC_MANIFEST_XML = "accessory_filter.xml";
    private XML xml;
    static boolean DEBUG = true;
    static final String ICON_72 = "icon-72.png";
    static final String ICON_48 = "icon-48.png";
    static final String ICON_36 = "icon-36.png";

    public MyBuild(Sketch sketch, AndroidMode androidMode) throws MyBadSDKException, IOException {
        super(sketch);
        if (this.sdk == null && DEBUG) {
            System.out.println("cannot configure your sdk, sorry");
        }
        File file = this.getCoreZipLocation();
        File file2 = new File(file.toString());
        String string = file2.getParent();
        String string2 = file2.getName();
        string = string + "/modes/android/";
        this.coreZipFile = new File(string + string2);
    }

    public File build(String string) throws IOException, SketchException {
        this.target = string;
        File file = this.createProject();
        if (file != null && !this.antBuild()) {
            return null;
        }
        return file;
    }

    protected boolean ignorableImport(String string) {
        if (string.startsWith("android.")) {
            return true;
        }
        if (string.startsWith("java.")) {
            return true;
        }
        if (string.startsWith("javax.")) {
            return true;
        }
        if (string.startsWith("org.apache.http.")) {
            return true;
        }
        if (string.startsWith("org.json.")) {
            return true;
        }
        if (string.startsWith("org.w3c.dom.")) {
            return true;
        }
        return string.startsWith("org.xml.sax.");
    }

    public File createProject() throws IOException, SketchException {
        this.tmpFolder = this.createTempBuildFolder(this.sketch);
        this.binFolder = this.srcFolder = new File(this.tmpFolder, "src");
        if (Base.DEBUG) {
            Base.openFolder((File)this.tmpFolder);
        }
        this.manifest = new Manifest(this.sketch);
        this.manifest.setPackageName(this.defaultPackageName());
        AndroidPreprocessor androidPreprocessor = new AndroidPreprocessor(this.sketch, this.getPackageName());
        this.sketchClassName = this.preprocess(this.srcFolder, this.manifest.getPackageName(), (PdePreprocessor)androidPreprocessor);
        if (this.sketchClassName != null) {
            File file = new File(this.tmpFolder, MANIFEST_XML);
            this.writeBuild(file, this.sketchClassName, this.target.equals("debug"));
            this.writeBuildProps(new File(this.tmpFolder, "build.properties"));
            this.buildFile = new File(this.tmpFolder, "build.xml");
            this.writeBuildXML(this.buildFile, this.sketch.getName());
            this.writeDefaultProps(new File(this.tmpFolder, "default.properties"));
            this.writeLocalProps(new File(this.tmpFolder, "local.properties"));
            File file2 = this.mkdirs(this.tmpFolder, "res");
            File file3 = this.mkdirs(file2, "xml");
            File file4 = new File(file3, ACC_MANIFEST_XML);
            try {
                Base.copyFile((File)this.getAccManifestFile(), (File)file4);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            this.writeRes(new File(this.tmpFolder, "res"), this.sketchClassName);
            File file5 = this.mkdirs(this.tmpFolder, "libs");
            File file6 = this.mkdirs(this.tmpFolder, "assets");
            Base.copyFile((File)this.coreZipFile, (File)new File(file5, "processing-core.jar"));
            this.copyLibraries(file5, file6);
            this.copyCodeFolder(file5);
            File file7 = this.sketch.getDataFolder();
            if (file7.exists()) {
                Base.copyDir((File)file7, (File)file6);
            }
        }
        return this.tmpFolder;
    }

    private File createTempBuildFolder(Sketch sketch) throws IOException {
        File file = File.createTempFile("android", ".pde");
        if (!file.delete() || !file.mkdir()) {
            throw new IOException("Cannot create temp dir " + file + " to build android sketch");
        }
        return file;
    }

    protected File createExportFolder() throws IOException {
        File file = new File(this.sketch.getFolder(), "android");
        if (file.exists()) {
            String string = AndroidMode.getDateStamp((long)file.lastModified());
            File file2 = new File(this.sketch.getFolder(), "android." + string);
            boolean bl = file.renameTo(file2);
            if (!bl) {
                ProcessResult processResult;
                try {
                    System.err.println("createProject renameTo() failed, resorting to mv/move instead.");
                    ProcessHelper processHelper = new ProcessHelper(new String[]{"mv", file.getAbsolutePath(), file2.getAbsolutePath()});
                    processResult = processHelper.execute();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return null;
                }
                if (!processResult.succeeded()) {
                    System.err.println(processResult.getStderr());
                    Base.showWarning((String)"Failed to rename", (String)("Could not rename the old \u201candroid\u201d build folder.\nPlease delete, close, or rename the folder\n" + file.getAbsolutePath() + "\n" + "and try again."), null);
                    Base.openFolder((File)this.sketch.getFolder());
                    return null;
                }
            }
        } else {
            boolean bl = file.mkdirs();
            if (!bl) {
                Base.showWarning((String)"Folders, folders, folders", (String)"Could not create the necessary folders to build.\nPerhaps you have some file permissions to sort out?", null);
                return null;
            }
        }
        return file;
    }

    public File exportProject() throws IOException, SketchException {
        File file = this.build("debug");
        if (file == null) {
            return null;
        }
        File file2 = this.createExportFolder();
        Base.copyDir((File)file, (File)file2);
        return file2;
    }

    public boolean exportPackage() throws IOException, SketchException {
        File file = this.build("release");
        if (file == null) {
            return false;
        }
        File file2 = this.createExportFolder();
        Base.copyDir((File)file, (File)file2);
        return true;
    }

    protected boolean antBuild() throws SketchException {
        Project project = new Project();
        String string = this.buildFile.getAbsolutePath().replace('\\', '/');
        project.setUserProperty("ant.file", string);
        project.setUserProperty("build.compiler", "extJavac");
        DefaultLogger defaultLogger = new DefaultLogger();
        defaultLogger.setErrorPrintStream(System.err);
        defaultLogger.setOutputPrintStream(System.out);
        defaultLogger.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)defaultLogger);
        DefaultLogger defaultLogger2 = new DefaultLogger();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        defaultLogger2.setErrorPrintStream(printStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        defaultLogger2.setOutputPrintStream(printStream2);
        defaultLogger2.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)defaultLogger2);
        try {
            project.fireBuildStarted();
            project.init();
            ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
            project.addReference("ant.projectHelper", (Object)projectHelper);
            projectHelper.parse(project, (Object)this.buildFile);
            project.executeTarget(this.target);
            return true;
        }
        catch (BuildException buildException) {
            SketchException sketchException;
            project.fireBuildFinished((Throwable)buildException);
            String string2 = new String(byteArrayOutputStream2.toByteArray());
            for (String string3 : sketchException = string2.split(System.getProperty("line.separator"))) {
                int n;
                int n2;
                String[] stringArray;
                int n3 = string3.indexOf("[javac]");
                if (n3 == -1 || (stringArray = PApplet.match((String)string3.substring(n2 = n3 + "[javac]".length() + 1), (String)"^(.+):([0-9]+):\\s+(.+)$")) == null) continue;
                String string4 = stringArray[1];
                SketchException sketchException2 = this.placeException(stringArray[3], string4 = string4.substring(string4.lastIndexOf(47) + 1), n = PApplet.parseInt((String)stringArray[2]) - 1);
                if (sketchException2 == null) continue;
                throw sketchException2;
            }
            SketchException sketchException3 = new SketchException("Error from inside the Android tools, check the console.");
            sketchException3.hideStackTrace();
            throw sketchException3;
        }
    }

    String getPathForAPK() {
        String string = this.target.equals("release") ? "unsigned" : "debug";
        String string2 = "bin/" + this.sketch.getName() + "-" + string + ".apk";
        File file = new File(this.tmpFolder, string2);
        return file.getAbsolutePath();
    }

    private void writeBuildProps(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("application-package=" + this.getPackageName());
        printWriter.flush();
        printWriter.close();
    }

    private void writeBuildXML(File file, String string) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<project name=\"" + string + "\" default=\"help\">");
        printWriter.println("  <property file=\"local.properties\"/>");
        printWriter.println("  <property file=\"build.properties\"/>");
        printWriter.println("  <property file=\"default.properties\"/>");
        printWriter.println("<import file=\"${sdk.dir}/tools/ant/build.xml\" />");
        printWriter.println("</project>");
        printWriter.flush();
        printWriter.close();
    }

    private void writeDefaultProps(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("target=Google Inc.:Google APIs:10");
        printWriter.flush();
        printWriter.close();
    }

    private void writeLocalProps(File file) {
        if (DEBUG) {
            System.out.println("using SDK folder: " + this.sdk.getSdkFolder().getAbsolutePath().toString());
        }
        PrintWriter printWriter = PApplet.createWriter((File)file);
        String string = this.sdk.getSdkFolder().getAbsolutePath();
        if (Base.isWindows()) {
            printWriter.println("sdk.dir=" + string.replace('\\', '/'));
        } else {
            printWriter.println("sdk.dir=" + string);
        }
        printWriter.flush();
        printWriter.close();
    }

    private void writeRes(File file, String string) throws SketchException {
        block14: {
            File file2 = this.mkdirs(file, "layout");
            File file3 = new File(file2, "main.xml");
            this.writeResLayoutMain(file3);
            File file4 = this.sketch.getFolder();
            File file5 = new File(file4, ICON_36);
            File file6 = new File(file4, ICON_48);
            File file7 = new File(file4, ICON_72);
            File file8 = new File(file, "drawable/icon.png");
            File file9 = new File(file, "drawable-ldpi/icon.png");
            File file10 = new File(file, "drawable-hdpi/icon.png");
            if (!(file5.exists() || file6.exists() || file7.exists())) {
                try {
                    if (file9.getParentFile().mkdirs()) {
                        Base.copyFile((File)this.mode.getContentFile("icons/icon-36.png"), (File)file9);
                    } else {
                        System.err.println("Could not create \"drawable-ldpi\" folder.");
                    }
                    if (file8.getParentFile().mkdirs()) {
                        Base.copyFile((File)this.mode.getContentFile("icons/icon-48.png"), (File)file8);
                    } else {
                        System.err.println("Could not create \"drawable\" folder.");
                    }
                    if (file10.getParentFile().mkdirs()) {
                        Base.copyFile((File)this.mode.getContentFile("icons/icon-72.png"), (File)file10);
                        break block14;
                    }
                    System.err.println("Could not create \"drawable-hdpi\" folder.");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                try {
                    if (file5.exists() && new File(file, "drawable-ldpi").mkdirs()) {
                        Base.copyFile((File)file5, (File)file9);
                    }
                    if (file6.exists() && new File(file, "drawable").mkdirs()) {
                        Base.copyFile((File)file6, (File)file8);
                    }
                    if (file7.exists() && new File(file, "drawable-hdpi").mkdirs()) {
                        Base.copyFile((File)file7, (File)file10);
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Problem while copying icons.");
                    iOException.printStackTrace();
                }
            }
        }
    }

    private File mkdirs(File file, String string) throws SketchException {
        File file2 = new File(file, string);
        if (!file2.exists() && !file2.mkdirs()) {
            throw new SketchException("Could not create " + file2);
        }
        return file2;
    }

    private void writeResLayoutMain(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printWriter.println("<LinearLayout xmlns:android=\"http://schemas.android.com/apk/res/android\"");
        printWriter.println("              android:orientation=\"vertical\"");
        printWriter.println("              android:layout_width=\"fill_parent\"");
        printWriter.println("              android:layout_height=\"fill_parent\">");
        printWriter.println("</LinearLayout>");
        printWriter.flush();
        printWriter.close();
    }

    private void copyLibraries(File file, File file2) throws IOException {
        for (Library library : this.getImportedLibraries()) {
            File file3 = new File(library.getPath());
            File file4 = new File(file3, "export.txt");
            HashMap hashMap = Base.readSettings((File)file4);
            String string = (String)hashMap.get("android");
            String[] stringArray = null;
            stringArray = string != null ? PApplet.splitTokens((String)string, (String)", ") : file3.list();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = PApplet.trim((String)stringArray[i]);
                if (stringArray[i].equals("") || stringArray[i].equals(".") || stringArray[i].equals("..")) continue;
                File file5 = new File(file3, stringArray[i]);
                if (!file5.exists()) {
                    System.err.println("File " + stringArray[i] + " does not exist");
                    continue;
                }
                if (file5.isDirectory()) {
                    System.err.println("Ignoring sub-folder \"" + stringArray[i] + "\"");
                    continue;
                }
                String string2 = file5.getName();
                String string3 = string2.toLowerCase();
                if (string3.endsWith(".zip") || string3.endsWith(".jar")) {
                    String string4 = string2.substring(0, string2.length() - 4) + ".jar";
                    Base.copyFile((File)file5, (File)new File(file, string4));
                    continue;
                }
                Base.copyFile((File)file5, (File)new File(file2, string2));
            }
        }
    }

    private void copyCodeFolder(File file) throws IOException {
        File file2 = this.sketch.getCodeFolder();
        if (file2 != null && file2.exists()) {
            for (File file3 : file2.listFiles()) {
                String string;
                String string2;
                if (file3.isDirectory() || !(string2 = (string = file3.getName()).toLowerCase()).endsWith(".jar") && !string2.endsWith(".zip")) continue;
                String string3 = string.substring(0, string.length() - 4) + ".jar";
                Base.copyFile((File)file3, (File)new File(file, string3));
            }
        }
    }

    protected String getPackageName() {
        return this.manifest.getPackageName();
    }

    public void cleanup() {
        this.tmpFolder.deleteOnExit();
    }

    protected File getCoreZipLocation() {
        if (this.coreZipLocation == null) {
            File file = new File("../../../android/core.zip");
            if (!file.exists() && Base.isMacOS()) {
                file = new File("../../../../../../../android/core.zip");
            }
            if (file.exists()) {
                System.out.println("Using version of core.zip from local SVN checkout.");
                this.coreZipLocation = file;
            }
            this.coreZipLocation = Base.getContentFile((String)"android-core.zip");
        }
        return this.coreZipLocation;
    }

    public static MyAndroidSDK getSDK() throws MyBadSDKException, IOException {
        String string;
        Platform platform = Base.getPlatform();
        if (DEBUG) {
            System.out.println(Preferences.get((String)"android.sdk.path"));
        }
        if ((string = platform.getenv("ANDROID_SDK")) == null) {
            string = Preferences.get((String)"android.sdk.path");
        }
        if (string != null) {
            try {
                MyAndroidSDK myAndroidSDK = new MyAndroidSDK(new File(string));
                Preferences.set((String)"android.sdk.path", (String)string);
                return myAndroidSDK;
            }
            catch (MyBadSDKException myBadSDKException) {
                // empty catch block
            }
        }
        if (DEBUG) {
            System.out.println("** HALT ** SDK not found, sorry");
        }
        return null;
    }

    protected void writeBuild(File file, String string, boolean bl) throws IOException {
        this.save(file);
        File file2 = new File(this.sketch.getFolder().toString() + "/AndroidManifest.xml");
        Base.copyFile((File)file2, (File)file);
        XML xML = new XML((Reader)new FileReader(file));
        String string2 = xML.getString("package").trim();
        if (string2.length() == 0) {
            xML.setString("package", this.defaultPackageName());
        }
        XML xML2 = xML.addChild("uses-sdk");
        xML2.setString("android:minSdkVersion", sdkVersion);
        XML xML3 = xML.addChild("uses-feature");
        xML3.setString("android:name", "android.hardware.usb.accessory");
        XML xML4 = xML.getChild("application");
        XML xML5 = xML4.addChild("uses-library");
        xML5.setString("android:name", "com.android.future.usb.accessory");
        String string3 = xML4.getString("android:label");
        if (string3.length() == 0) {
            xML4.setString("android:label", string);
        }
        xML4.setString("android:debuggable", bl ? "true" : "false");
        XML xML6 = xML4.getChild("activity");
        xML6.setString("android:name", "." + string);
        XML xML7 = xML6.addChild("meta-data");
        xML7.setString("android:name", "android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
        xML7.setString("android:resource", "@xml/accessory_filter");
        XML xML8 = xML6.getChild("intent-filter");
        XML xML9 = xML8.addChild("action");
        xML9.setString("android:name", "android.hardware.usb.action.USB_ACCESSORY_ATTACHED");
        PrintWriter printWriter = PApplet.createWriter((File)file);
        try {
            printWriter.print(xML.toString());
            printWriter.flush();
            printWriter.close();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("error generating the manifest file");
        }
    }

    protected void save() {
        this.save(this.getManifestFile());
    }

    protected void save(File file) {
        PrintWriter printWriter = PApplet.createWriter((File)file);
        try {
            printWriter.print(this.xml.toString());
            printWriter.flush();
            printWriter.close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private File getManifestFile() {
        return new File(this.sketch.getFolder(), MANIFEST_XML);
    }

    private File getAccManifestFile() {
        return new File(this.sketch.getFolder(), ACC_MANIFEST_XML);
    }

    private String defaultPackageName() {
        return "processing.android.test." + this.sketch.getName().toLowerCase();
    }
}

