/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.adk.processing;

import cc.arduino.adk.processing.MyBadSDKException;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.core.PApplet;
import processing.mode.android.AndroidMode;

class MyAndroidSDK {
    private final File folder;
    private final File tools;
    private final File platformTools;
    private final File androidTool;
    private static final String ANDROID_SDK_PRIMARY = "Is the Android SDK installed?";
    private static final String ANDROID_SDK_SECONDARY = "The Android SDK does not appear to be installed, <br>because the ANDROID_SDK variable is not set. <br>If it is installed, click \u201cYes\u201d to select the <br>location of the SDK, or \u201cNo\u201d to visit the SDK<br>download site at http://developer.android.com/sdk.";
    private static final String SELECT_ANDROID_SDK_FOLDER = "Choose the location of the Android SDK";
    private static final String NOT_ANDROID_SDK = "The selected folder does not appear to contain an Android SDK,\nor the SDK needs to be updated to the latest version.";
    private static final String ANDROID_SDK_URL = "http://developer.android.com/sdk/";
    private static final String ADB_DAEMON_MSG_1 = "daemon not running";
    private static final String ADB_DAEMON_MSG_2 = "daemon started successfully";

    public MyAndroidSDK(File file) throws MyBadSDKException, IOException {
        this.folder = file;
        if (!file.exists()) {
            throw new MyBadSDKException(file + " does not exist");
        }
        this.tools = new File(file, "tools");
        if (!this.tools.exists()) {
            throw new MyBadSDKException("There is no tools folder in " + file);
        }
        this.platformTools = new File(file, "platform-tools");
        if (!this.platformTools.exists()) {
            throw new MyBadSDKException("There is no platform-tools folder in " + file);
        }
        this.androidTool = MyAndroidSDK.findAndroidTool(this.tools);
        Platform platform = Base.getPlatform();
        String string = platform.getenv("PATH");
        platform.setenv("ANDROID_SDK", file.getCanonicalPath());
        string = this.platformTools.getCanonicalPath() + File.pathSeparator + this.tools.getCanonicalPath() + File.pathSeparator + string;
        String string2 = System.getProperty("java.home");
        File file2 = new File(string2).getCanonicalFile();
        platform.setenv("JAVA_HOME", file2.getCanonicalPath());
        string = new File(file2, "bin").getCanonicalPath() + File.pathSeparator + string;
        platform.setenv("PATH", string);
        this.checkDebugCertificate();
    }

    protected void checkDebugCertificate() {
        File file = new File(System.getProperty("user.home"), ".android");
        File file2 = new File(file, "debug.keystore");
        if (file2.exists()) {
            ProcessHelper processHelper = new ProcessHelper(new String[]{"keytool", "-list", "-v", "-storepass", "android", "-keystore", file2.getAbsolutePath()});
            try {
                ProcessResult processResult = processHelper.execute();
                if (processResult.succeeded()) {
                    String[] stringArray;
                    for (String string : stringArray = PApplet.split((String)processResult.getStdout(), (char)'\n')) {
                        String[] stringArray2 = PApplet.match((String)string, (String)"Valid from: .* until: (.*)");
                        if (stringArray2 == null) continue;
                        String string2 = stringArray2[1];
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
                        try {
                            Date date = simpleDateFormat.parse(string2);
                            long l = date.getTime();
                            if (l >= System.currentTimeMillis()) continue;
                            System.out.println("Removing expired debug.keystore file.");
                            String string3 = "debug.keystore." + AndroidMode.getDateStamp((long)l);
                            File file3 = new File(file2.getParent(), string3);
                            if (file2.renameTo(file3)) continue;
                            System.err.println("Could not remove the expired debug.keystore file.");
                            System.err.println("Please remove the file " + file2.getAbsolutePath());
                        }
                        catch (ParseException parseException) {
                            System.err.println("The date \u201c" + string2 + "\u201d could not be parsed.");
                            System.err.println("Please report this as a bug so we can fix it.");
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public File getAndroidTool() {
        return this.androidTool;
    }

    public String getAndroidToolPath() {
        return this.androidTool.getAbsolutePath();
    }

    public File getSdkFolder() {
        return this.folder;
    }

    public File getPlatformToolsFolder() {
        return this.platformTools;
    }

    private static File findAndroidTool(File file) throws MyBadSDKException {
        if (new File(file, "android.exe").exists()) {
            return new File(file, "android.exe");
        }
        if (new File(file, "android.bat").exists()) {
            return new File(file, "android.bat");
        }
        if (new File(file, "android").exists()) {
            return new File(file, "android");
        }
        throw new MyBadSDKException("Cannot find the android tool in " + file);
    }

    public static MyAndroidSDK load() throws MyBadSDKException, IOException {
        String string;
        Platform platform = Base.getPlatform();
        String string2 = platform.getenv("ANDROID_SDK");
        if (string2 != null) {
            try {
                MyAndroidSDK myAndroidSDK = new MyAndroidSDK(new File(string2));
                Preferences.set((String)"android.sdk.path", (String)string2);
                return myAndroidSDK;
            }
            catch (MyBadSDKException myBadSDKException) {
                // empty catch block
            }
        }
        if ((string = Preferences.get((String)"android.sdk.path")) != null) {
            try {
                MyAndroidSDK myAndroidSDK = new MyAndroidSDK(new File(string));
                Preferences.set((String)"android.sdk.path", (String)string);
                return myAndroidSDK;
            }
            catch (MyBadSDKException myBadSDKException) {
                Preferences.unset((String)"android.sdk.path");
            }
        }
        return null;
    }

    public static MyAndroidSDK locate(Frame frame) throws MyBadSDKException, IOException {
        int n = Base.showYesNoQuestion((Frame)frame, (String)"Android SDK", (String)ANDROID_SDK_PRIMARY, (String)ANDROID_SDK_SECONDARY);
        if (n == 2) {
            throw new MyBadSDKException("User canceled attempt to find SDK.");
        }
        if (n == 1) {
            Base.openURL((String)ANDROID_SDK_URL);
            throw new MyBadSDKException("No SDK installed.");
        }
        while (true) {
            File file;
            if ((file = Base.selectFolder((String)SELECT_ANDROID_SDK_FOLDER, null, (Frame)frame)) == null) {
                throw new MyBadSDKException("User canceled attempt to find SDK.");
            }
            try {
                MyAndroidSDK myAndroidSDK = new MyAndroidSDK(file);
                Preferences.set((String)"android.sdk.path", (String)file.getAbsolutePath());
                return myAndroidSDK;
            }
            catch (MyBadSDKException myBadSDKException) {
                JOptionPane.showMessageDialog(frame, NOT_ANDROID_SDK);
                continue;
            }
            break;
        }
    }

    public static ProcessResult runADB(String ... stringArray) throws InterruptedException, IOException {
        ProcessResult processResult;
        String string;
        String[] stringArray2 = !stringArray[0].equals("adb") ? PApplet.splice((String[])stringArray, (String)"adb", (int)0) : stringArray;
        if (Base.DEBUG) {
            PApplet.println((Object)stringArray2);
        }
        if ((string = (processResult = new ProcessHelper(stringArray2).execute()).getStdout()).contains(ADB_DAEMON_MSG_1) && string.contains(ADB_DAEMON_MSG_2)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : string.split("\n")) {
                if (string.contains(ADB_DAEMON_MSG_1) || string.contains(ADB_DAEMON_MSG_2)) continue;
                stringBuilder.append(string2).append("\n");
            }
            return new ProcessResult(processResult.getCmd(), processResult.getResult(), stringBuilder.toString(), processResult.getStderr(), processResult.getTime());
        }
        return processResult;
    }
}

