/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.adk.processing;

import cc.arduino.adk.processing.MyAndroidSDK;
import java.io.IOException;
import java.util.ArrayList;
import processing.app.Base;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.core.PApplet;

public class MyAVD {
    private static final String AVD_CREATE_PRIMARY = "An error occurred while running \u201candroid create avd\u201d";
    private static final String AVD_CREATE_SECONDARY = "The default Android emulator could not be set up. Make sure<br>that the Android SDK is installed properly, and that the<br>Android and Google APIs are installed for level 10.<br>(Between you and me, occasionally, this error is a red herring,<br>and your sketch may be launching shortly.)";
    private static final String AVD_LOAD_PRIMARY = "There is an error with the Processing AVD.";
    private static final String AVD_LOAD_SECONDARY = "This could mean that the Android tools need to be updated,<br>or that the Processing AVD should be deleted (it will<br>automatically re-created the next time you run Processing).<br>Open the Android SDK manager to check for any errors.";
    private static final String AVD_TARGET_PRIMARY = "The Google APIs are not installed properly";
    private static final String AVD_TARGET_SECONDARY = "Please re-read the installation instructions for Processing<br>found at http://android.processing.org and try again.";
    static final String DEFAULT_SKIN = "WVGA800";
    protected String name;
    protected String target;
    public static final MyAVD defaultAVD = new MyAVD("Processing-0203", "Google Inc.:Google APIs:10");
    static ArrayList<String> avdList;
    static ArrayList<String> badList;

    public MyAVD(String string, String string2) {
        this.name = string;
        this.target = string2;
    }

    protected static void list(MyAndroidSDK myAndroidSDK) throws IOException {
        try {
            avdList = new ArrayList();
            badList = new ArrayList();
            ProcessResult processResult = new ProcessHelper(new String[]{myAndroidSDK.getAndroidToolPath(), "list", "avds"}).execute();
            if (processResult.succeeded()) {
                boolean bl = false;
                for (String string : processResult) {
                    String[] stringArray = PApplet.match((String)string, (String)"\\s+Name\\:\\s+(\\S+)");
                    if (stringArray != null) {
                        if (!bl) {
                            avdList.add(stringArray[1]);
                        } else {
                            badList.add(stringArray[1]);
                        }
                    }
                    if (!string.contains("could not be loaded:")) continue;
                    bl = true;
                }
            } else {
                System.err.println("Unhappy inside exists()");
                System.err.println(processResult);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected boolean exists(MyAndroidSDK myAndroidSDK) throws IOException {
        if (avdList == null) {
            MyAVD.list(myAndroidSDK);
        }
        for (String string : avdList) {
            if (!string.equals(this.name)) continue;
            return true;
        }
        return false;
    }

    protected boolean badness() {
        for (String string : badList) {
            if (!string.equals(this.name)) continue;
            return true;
        }
        return false;
    }

    protected boolean create(MyAndroidSDK myAndroidSDK) throws IOException {
        String[] stringArray = new String[]{myAndroidSDK.getAndroidToolPath(), "create", "avd", "-n", this.name, "-t", this.target, "-c", "64M", "-s", DEFAULT_SKIN};
        ProcessHelper processHelper = new ProcessHelper(stringArray);
        try {
            ProcessResult processResult = processHelper.execute();
            if (processResult.succeeded()) {
                return true;
            }
            if (processResult.toString().contains("Target id is not valid")) {
                Base.showWarningTiered((String)"Android Error", (String)AVD_TARGET_PRIMARY, (String)AVD_TARGET_SECONDARY, null);
            } else {
                Base.showWarningTiered((String)"Android Error", (String)AVD_CREATE_PRIMARY, (String)AVD_CREATE_SECONDARY, null);
                System.out.println(processResult);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public static boolean ensureEclairAVD(MyAndroidSDK myAndroidSDK) {
        try {
            if (defaultAVD.exists(myAndroidSDK)) {
                return true;
            }
            if (defaultAVD.badness()) {
                Base.showWarningTiered((String)"Android Error", (String)AVD_LOAD_PRIMARY, (String)AVD_LOAD_SECONDARY, null);
                return false;
            }
            if (defaultAVD.create(myAndroidSDK)) {
                return true;
            }
        }
        catch (Exception exception) {
            Base.showWarningTiered((String)"Android Error", (String)AVD_CREATE_PRIMARY, (String)AVD_CREATE_SECONDARY, null);
        }
        return false;
    }
}

