/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.adk.processing;

import cc.arduino.adk.processing.MyCompileThread;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.tools.Tool;
import processing.core.PApplet;

public class Arduino_ADK
extends JFrame
implements Tool,
ActionListener {
    private static final long serialVersionUID = 1L;
    Editor editor;
    private JPanel contentPane;
    private JTextField textModel;
    private JTextField textManufacturer;
    private JButton btnSave;
    private JLabel lblVersion;
    private JTextField textVersion;

    public String getMenuTitle() {
        return "Arduino ADK";
    }

    public void init(Editor editor) {
        this.editor = editor;
    }

    public void run() {
        Sketch sketch = this.editor.getSketch();
        try {
            sketch.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.loadGUI();
        this.setVisible(true);
        this.loadInformation();
        System.out.println("Arduino_ADK 0.1a");
        System.out.println("by D. Cuartielles, A. Goransson");
        System.out.println("at http://arduino.cc, http://1scale1.com");
        this.editor.statusNotice("Arduino_ADK launched");
    }

    public void loadGUI() {
        this.setDefaultCloseOperation(0);
        this.setBounds(100, 100, 250, 120);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.contentPane.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Model");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.contentPane.add((Component)jLabel, gridBagConstraints);
        this.textModel = new JTextField();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        this.contentPane.add((Component)this.textModel, gridBagConstraints2);
        this.textModel.setColumns(10);
        JLabel jLabel2 = new JLabel("Manufacturer");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        this.contentPane.add((Component)jLabel2, gridBagConstraints3);
        this.textManufacturer = new JTextField();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        this.contentPane.add((Component)this.textManufacturer, gridBagConstraints4);
        this.textManufacturer.setColumns(10);
        this.btnSave = new JButton("Run on Device");
        this.btnSave.addActionListener(this);
        this.lblVersion = new JLabel("Version");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        this.contentPane.add((Component)this.lblVersion, gridBagConstraints5);
        this.textVersion = new JTextField();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        this.contentPane.add((Component)this.textVersion, gridBagConstraints6);
        this.textVersion.setColumns(10);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 3;
        this.contentPane.add((Component)this.btnSave, gridBagConstraints7);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Arduino_ADK closed without uploading");
                Arduino_ADK.this.editor.statusError("Arduino_ADK closed without uploading");
                Arduino_ADK.this.editor.stopIndeterminate();
                Arduino_ADK.this.dispose();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.editor.startIndeterminate();
        this.editor.statusNotice("writing accessory manifest");
        String string = this.textModel.getText().trim();
        String string2 = this.textManufacturer.getText().trim();
        String string3 = this.textVersion.getText().trim();
        String[] stringArray = PApplet.loadStrings((File)new File(this.editor.getSketch().getFolder(), "accessory_filter.xml"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("manufacturer=\"") <= -1) continue;
            String string4 = stringArray[i];
            stringArray[i] = string4 = "<usb-accessory manufacturer=\"" + string2 + "\" model=\"" + string + "\" version=\"" + string3 + "\" />";
        }
        PrintWriter printWriter = PApplet.createWriter((File)new File(this.editor.getSketch().getFolder(), "accessory_filter.xml"));
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.println(stringArray[i]);
        }
        printWriter.flush();
        printWriter.close();
        MyCompileThread myCompileThread = new MyCompileThread(this.editor);
        this.dispose();
    }

    private void loadInformation() {
        File file = new File(this.editor.getSketch().getFolder(), "accessory_filter.xml");
        if (file.exists()) {
            String[] stringArray = PApplet.loadStrings((File)file);
            PApplet.println((String)("TEST TEST: " + stringArray.length));
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf("manufacturer=\"") <= -1) continue;
                String string = "manufacturer=\"";
                int n = stringArray[i].indexOf(string);
                int n2 = stringArray[i].indexOf("\"", n + string.length());
                this.textManufacturer.setText(stringArray[i].substring(n + string.length(), n2));
                String string2 = "model=\"";
                int n3 = stringArray[i].indexOf(string2);
                int n4 = stringArray[i].indexOf("\"", n3 + string2.length());
                this.textModel.setText(stringArray[i].substring(n3 + string2.length(), n4));
                String string3 = "version=\"";
                int n5 = stringArray[i].indexOf(string3);
                int n6 = stringArray[i].indexOf("\"", n5 + string3.length());
                this.textVersion.setText(stringArray[i].substring(n5 + string3.length(), n6));
            }
        } else {
            String string = "Mega_ADK";
            String string4 = "Arduino SA";
            String string5 = "1.0";
            PrintWriter printWriter = PApplet.createWriter((File)file);
            printWriter.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            printWriter.println("<resources>");
            printWriter.println("<usb-accessory manufacturer=\"" + string4 + "\" model=\"" + string + "\" version=\"" + string5 + "\" />");
            printWriter.println("</resources>");
            printWriter.flush();
            printWriter.close();
            this.loadInformation();
        }
    }
}

