package edu.ozyegin.gizmo_test;

import android.bluetooth.BluetoothAdapter;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.support.v7.app.ActionBarActivity;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

import java.lang.ref.WeakReference;


public class MainActivity extends ActionBarActivity {
    private String address;
    private String commandLeft;
    private String commandRight;
    private String commandBlade;
    private String commandFire;
    private cBluetooth bl = null;
    private boolean BT_is_connect;

    private String fireState = "0";
    private String bladeState = "0";

    public static final int LEFT = 0;
    public static final int RIGHT = 1;

    private VerticalSeekBar vSeekBar[];
    private TextView tv_sb[];
    private ToggleButton tb_connect;
    private ImageButton ib_fire;
    private ToggleButton tb_blade;
    private Button bt_panic, bt_boostF,bt_boostB;

    private int motorValue[];
    public static final int VALUE_BAR_MAX_RIGHT = 35;
    public static final int VALUE_BAR_MAX_LEFT = 35;
    public static final int VALUE_BAR_STOP = 19;
    public static final int VALUE_MOTOR_STOP = 90;
    public static final int VALUE_MOTOR_BOOSTB_RIGHT = 130;
    public static final int VALUE_MOTOR_BOOSTB_LEFT = 130;
    public static final int VALUE_MOTOR_BOOSTF_RIGHT = 60;
    public static final int VALUE_MOTOR_BOOSTF_LEFT = 60;

    public static final int INTERVAL_SEND = 100;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        address = (String) getResources().getText(R.string.default_MAC);
        commandLeft = (String) getResources().getText(R.string.default_commandLeft);
        commandRight = (String) getResources().getText(R.string.default_commandRight);
        commandBlade = (String) getResources().getText(R.string.default_commandBlade);
        commandFire = (String) getResources().getText(R.string.default_commandFire);

        loadPref();

        bl = new cBluetooth(this, mHandler);
        bl.checkBTState();

        tb_blade = (ToggleButton) findViewById(R.id.tb_blade);
        tb_blade.setEnabled(false);
        tb_blade.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                //TODO
                if(isChecked){
                    bladeState = "1";
                }else{
                    bladeState = "0";
                }
            }
        });

        ib_fire = (ImageButton) findViewById(R.id.ib_fire);
        ib_fire.setOnTouchListener(fireTouchListener);
        ib_fire.setEnabled(false);
        ib_fire.setImageResource(R.drawable.fire_but_disabled);
        ib_fire.invalidate();

        bt_panic = (Button) findViewById(R.id.bt_panic);
        bt_panic.setOnTouchListener(panicTouchListener);

        bt_boostB = (Button) findViewById(R.id.bt_boostB);
        bt_boostB.setOnTouchListener(boostTouchListener);
        bt_boostF = (Button) findViewById(R.id.bt_boostF);
        bt_boostF.setOnTouchListener(boostTouchListener);

        tb_connect = (ToggleButton) findViewById(R.id.tb_connect);

        tb_connect.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    tb_connect.setEnabled(false);
                    BT_is_connect = bl.BT_Connect(address, false);
                    if (BT_is_connect) {
                        tb_connect.setEnabled(true);
                        ib_fire.setEnabled(true);
                        ib_fire.setImageResource(R.drawable.fire_but);
                        ib_fire.invalidate();
                        tb_blade.setEnabled(true);
                        vSeekBar[RIGHT].setEnabled(true);
                        vSeekBar[LEFT].setEnabled(true);
                        sendHandler.post(runnable);
                    } else {
                        tb_connect.setEnabled(true);
                        tb_connect.setChecked(false);
                    }
                } else {
                    sendHandler.removeCallbacks(runnable);
                    tb_connect.setEnabled(false);
                    if (BT_is_connect)
                        bl.BT_onPause();
                    BT_is_connect = false;
                    tb_connect.setEnabled(true);
                    ib_fire.setEnabled(false);
                    ib_fire.setImageResource(R.drawable.fire_but_disabled);
                    ib_fire.invalidate();
                    tb_blade.setEnabled(false);
                    vSeekBar[RIGHT].setEnabled(false);
                    vSeekBar[LEFT].setEnabled(false);
                }
            }
        });

        motorValue = new int[2];
        motorValue[LEFT] = VALUE_MOTOR_STOP;
        motorValue[RIGHT] = VALUE_MOTOR_STOP;

        tv_sb = new TextView[2];
        tv_sb[LEFT] = (TextView) findViewById(R.id.tv_sbLeft);
        tv_sb[RIGHT] = (TextView) findViewById(R.id.tv_sbRight);

        vSeekBar = new VerticalSeekBar[2];

        vSeekBar[RIGHT] = (VerticalSeekBar) findViewById(R.id.sb_right);
        vSeekBar[RIGHT].setMaximum(VALUE_BAR_MAX_RIGHT);
        vSeekBar[RIGHT].setEnabled(false);

        vSeekBar[LEFT] = (VerticalSeekBar) findViewById(R.id.sb_left);
        vSeekBar[LEFT].setMaximum(VALUE_BAR_MAX_LEFT);
        vSeekBar[LEFT].setEnabled(false);

        vSeekBar[RIGHT].setOnSeekBarChangeListener(new VerticalSeekBar.OnSeekBarChangeListener() {

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                //Toast.makeText(getBaseContext(), String.valueOf(seekBar.getProgress()), Toast.LENGTH_SHORT).show();
                //MotionChanged(xgl,progress);

                if (progress < VALUE_BAR_STOP)
                    motorValue[RIGHT] = Math.abs(progress - 120);
                else if (progress > VALUE_BAR_STOP)
                    motorValue[RIGHT] = progress + 40;
                else if (progress == VALUE_BAR_STOP)
                    motorValue[RIGHT] = VALUE_MOTOR_STOP;

                tv_sb[RIGHT].setText(Integer.toString(motorValue[RIGHT]));
            }

            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                vSeekBar[RIGHT].setProgressAndThumb(VALUE_BAR_STOP);
                motorValue[RIGHT] = VALUE_MOTOR_STOP;
                tv_sb[RIGHT].setText(Integer.toString(motorValue[RIGHT]));
            }
        });

        vSeekBar[LEFT].setOnSeekBarChangeListener(new VerticalSeekBar.OnSeekBarChangeListener() {

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                //Toast.makeText(getBaseContext(), String.valueOf(seekBar.getProgress()), Toast.LENGTH_SHORT).show();
                //MotionChanged(xgl,progress);
                if (progress < VALUE_BAR_STOP)
                    motorValue[LEFT] = Math.abs(progress - 120);
                else if (progress > VALUE_BAR_STOP)
                    motorValue[LEFT] = progress + 40;
                else if (progress == VALUE_BAR_STOP)
                    motorValue[LEFT] = VALUE_MOTOR_STOP;

                tv_sb[LEFT].setText(Integer.toString(motorValue[LEFT]));
            }

            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                vSeekBar[LEFT].setProgressAndThumb(VALUE_BAR_STOP);
                motorValue[LEFT] = VALUE_MOTOR_STOP;
                tv_sb[LEFT].setText(Integer.toString(motorValue[LEFT]));
            }
        });




        mHandler.postDelayed(sRunnable, 600000);
    }

    View.OnTouchListener fireTouchListener = new View.OnTouchListener() {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    ib_fire.setImageResource(R.drawable.fire_but_pressed);
                    ib_fire.invalidate();
                    fireState = "1";
                    //TODO send code
                    return true;
                case MotionEvent.ACTION_UP:
                    ib_fire.setImageResource(R.drawable.fire_but);
                    ib_fire.invalidate();
                    fireState = "0";
                    //TODO send code
                    return true;
            }
            return false;
        }
    };


    View.OnTouchListener panicTouchListener = new View.OnTouchListener() {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    bt_panic.setBackgroundColor(0xFFFF4444);
                    bt_panic.invalidate();
                    //TODO send code
                    return true;
                case MotionEvent.ACTION_UP:
                    bt_panic.setBackgroundColor(0xFFCC0000);
                    bt_panic.invalidate();

                    vSeekBar[RIGHT].setProgress(VALUE_BAR_STOP);
                    vSeekBar[LEFT].setProgress(VALUE_BAR_STOP);
                    motorValue[RIGHT] = VALUE_MOTOR_STOP;
                    tv_sb[RIGHT].setText(Integer.toString(motorValue[RIGHT]));
                    motorValue[LEFT] = VALUE_MOTOR_STOP;
                    tv_sb[LEFT].setText(Integer.toString(motorValue[LEFT]));

                    fireState = "0";
                    bladeState = "0";
                    tb_blade.setChecked(false);

                    //TODO send code
                    return true;
            }
            return false;
        }
    };

    View.OnTouchListener boostTouchListener = new View.OnTouchListener() {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    if(v.getId() == R.id.bt_boostB) {
                        bt_boostB.setBackgroundColor(0xFF99CC00);
                        bt_boostB.invalidate();
                        motorValue[RIGHT] = VALUE_MOTOR_BOOSTB_RIGHT;
                        motorValue[LEFT] = VALUE_MOTOR_BOOSTB_LEFT;
                    }else if(v.getId() == R.id.bt_boostF) {
                        bt_boostF.setBackgroundColor(0xFF99CC00);
                        bt_boostF.invalidate();
                        motorValue[RIGHT] = VALUE_MOTOR_BOOSTF_RIGHT;
                        motorValue[LEFT] = VALUE_MOTOR_BOOSTF_LEFT;
                    }

                    tv_sb[RIGHT].setText(Integer.toString(motorValue[RIGHT]));
                    tv_sb[LEFT].setText(Integer.toString(motorValue[LEFT]));

                    return true;
                case MotionEvent.ACTION_UP:
                    if(v.getId() == R.id.bt_boostB) {
                        bt_boostB.setBackgroundColor(0xFF669900);
                        bt_boostB.invalidate();
                    }else if(v.getId() == R.id.bt_boostF) {
                        bt_boostF.setBackgroundColor(0xFF669900);
                        bt_boostF.invalidate();
                    }

                    motorValue[RIGHT] = VALUE_MOTOR_STOP;
                    tv_sb[RIGHT].setText(Integer.toString(motorValue[RIGHT]));
                    motorValue[LEFT] = VALUE_MOTOR_STOP;
                    tv_sb[LEFT].setText(Integer.toString(motorValue[LEFT]));

                    return true;
            }
            return false;
        }
    };


    private static class MyHandler extends Handler {
        private final WeakReference<MainActivity> mActivity;

        public MyHandler(MainActivity activity) {
            mActivity = new WeakReference<MainActivity>(activity);
        }

        @Override
        public void handleMessage(Message msg) {
            MainActivity activity = mActivity.get();
            if (activity != null) {
                switch (msg.what) {
                    case cBluetooth.BL_NOT_AVAILABLE:
                        Log.d(cBluetooth.TAG, "Bluetooth is not available. Exit");
                        Toast.makeText(activity.getBaseContext(), "Bluetooth is not available", Toast.LENGTH_SHORT).show();
                        activity.finish();
                        break;
                    case cBluetooth.BL_INCORRECT_ADDRESS:
                        Log.d(cBluetooth.TAG, "Incorrect MAC address");
                        Toast.makeText(activity.getBaseContext(), "Incorrect Bluetooth address", Toast.LENGTH_SHORT).show();
                        break;
                    case cBluetooth.BL_REQUEST_ENABLE:
                        Log.d(cBluetooth.TAG, "Request Bluetooth Enable");
                        BluetoothAdapter.getDefaultAdapter();
                        Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
                        activity.startActivityForResult(enableBtIntent, 1);
                        break;
                    case cBluetooth.BL_SOCKET_FAILED:
                        Toast.makeText(activity.getBaseContext(), "Socket failed", Toast.LENGTH_SHORT).show();
                        //activity.finish();
                        break;
                }
            }
        }
    }

    private void motorChanged() {
        String cmdSendL, cmdSendR, cmdSendB, cmdSendF;

        cmdSendL = String.valueOf(commandLeft + motorValue[LEFT] + "\r");
        cmdSendR = String.valueOf(commandRight + motorValue[RIGHT] + "\r");
        cmdSendB = String.valueOf(commandBlade + bladeState + "\r");
        cmdSendF = String.valueOf(commandFire + fireState + "\r");

        if (BT_is_connect) bl.sendData(cmdSendL + cmdSendR + cmdSendB + cmdSendF);

    }

    private final MyHandler mHandler = new MyHandler(this);
    private final Handler sendHandler = new Handler();

    private Runnable runnable = new Runnable() {
        @Override
        public void run() {
            BT_is_connect = bl.checkBTState();

            if (BT_is_connect) {
                motorChanged();
                sendHandler.postDelayed(this, INTERVAL_SEND);
            }
        }
    };

    private final static Runnable sRunnable = new Runnable() {
        public void run() {
        }
    };

    private void loadPref() {
        SharedPreferences mySharedPreferences = PreferenceManager.getDefaultSharedPreferences(this);

        address = mySharedPreferences.getString("pref_MAC_address", address);            // the first time we load the default values (?????? ??? ????????? ????????? ????????)
        commandLeft = mySharedPreferences.getString("pref_commandLeft", commandLeft);
        commandRight = mySharedPreferences.getString("pref_commandRight", commandRight);
        //commandHorn = mySharedPreferences.getString("pref_commandHorn", commandHorn);
    }

    @Override
    protected void onResume() {

        super.onResume();
        if(tb_connect.isChecked())
            tb_connect.setChecked(false);

    }

    @Override
    protected void onPause() {
        super.onPause();
        sendHandler.removeCallbacks(runnable);
        bl.BT_onPause();
        BT_is_connect = false;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        loadPref();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {

        Intent intent = new Intent();
        intent.setClass(MainActivity.this, SetPreferenceActivity.class);
        startActivityForResult(intent, 0);

        return true;
    }
}
