/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.support.annotation.NonNull;
import android.util.Log;
import com.android.build.gradle.internal.incremental.PatchesLoader;
import com.android.tools.fd.runtime.AppInfo;
import com.android.tools.fd.runtime.ApplicationPatch;
import com.android.tools.fd.runtime.FileManager;
import com.android.tools.fd.runtime.MonkeyPatcher;
import com.android.tools.fd.runtime.Restarter;
import dalvik.system.DexClassLoader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.List;

public class Server {
    public static final long PROTOCOL_IDENTIFIER = 890269988L;
    public static final int PROTOCOL_VERSION = 4;
    public static final int MESSAGE_PATCHES = 1;
    public static final int MESSAGE_PING = 2;
    public static final int MESSAGE_PATH_EXISTS = 3;
    public static final int MESSAGE_PATH_CHECKSUM = 4;
    public static final int MESSAGE_RESTART_ACTIVITY = 5;
    public static final int MESSAGE_SHOW_TOAST = 6;
    public static final int MESSAGE_EOF = 7;
    public static final int UPDATE_MODE_NONE = 0;
    public static final int UPDATE_MODE_HOT_SWAP = 1;
    public static final int UPDATE_MODE_WARM_SWAP = 2;
    public static final int UPDATE_MODE_COLD_SWAP = 3;
    private LocalServerSocket mServerSocket;
    private final Application mApplication;
    private static int mWrongTokenCount;

    public static void create(@NonNull String packageName, @NonNull Application application) {
        new Server(packageName, application);
    }

    private Server(@NonNull String packageName, @NonNull Application application) {
        this.mApplication = application;
        try {
            this.mServerSocket = new LocalServerSocket(packageName);
            if (Log.isLoggable((String)"fd", (int)4)) {
                Log.i((String)"fd", (String)("Starting server socket listening for package " + packageName + " on " + this.mServerSocket.getLocalSocketAddress()));
            }
        }
        catch (IOException e) {
            Log.e((String)"fd", (String)("IO Error creating local socket at " + packageName), (Throwable)e);
            return;
        }
        this.startServer();
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)("Started server for package " + packageName));
        }
    }

    private void startServer() {
        try {
            Thread socketServerThread = new Thread(new SocketServerThread());
            socketServerThread.start();
        }
        catch (Throwable e) {
            Log.i((String)"fd", (String)"Fatal error starting server", (Throwable)e);
        }
    }

    private boolean hasResources(@NonNull List<ApplicationPatch> changes) {
        for (ApplicationPatch change : changes) {
            String path = change.getPath();
            if (path.endsWith(".dex") || path.endsWith(".dex.3")) continue;
            return true;
        }
        return false;
    }

    private int handlePatches(@NonNull List<ApplicationPatch> changes, boolean hasResources, int updateMode) {
        if (hasResources) {
            FileManager.startUpdate();
        }
        for (ApplicationPatch change : changes) {
            String path = change.getPath();
            if (path.endsWith(".dex")) {
                this.handleColdSwapPatch(change);
                continue;
            }
            if (path.endsWith(".dex.3")) {
                updateMode = this.handleHotSwapPatch(updateMode, change);
                continue;
            }
            updateMode = this.handleResourcePatch(updateMode, change, path);
        }
        if (hasResources) {
            FileManager.finishUpdate(true);
        }
        return updateMode;
    }

    private int handleResourcePatch(int updateMode, @NonNull ApplicationPatch patch, @NonNull String path) {
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)("Received resource changes (" + path + ")"));
        }
        FileManager.writeAaptResources(path, patch.getBytes());
        updateMode = Math.max(updateMode, 2);
        return updateMode;
    }

    private int handleHotSwapPatch(int updateMode, @NonNull ApplicationPatch patch) {
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)"Received incremental code patch");
        }
        try {
            String dexFile = FileManager.writeTempDexFile(patch.getBytes());
            if (dexFile == null) {
                Log.e((String)"fd", (String)"No file to write the code to");
                return updateMode;
            }
            if (Log.isLoggable((String)"fd", (int)4)) {
                Log.i((String)"fd", (String)("Reading live code from " + dexFile));
            }
            String nativeLibraryPath = FileManager.getNativeLibraryFolder().getPath();
            DexClassLoader dexClassLoader = new DexClassLoader(dexFile, this.mApplication.getCacheDir().getPath(), nativeLibraryPath, this.getClass().getClassLoader());
            Class<?> aClass = Class.forName("com.android.build.gradle.internal.incremental.AppPatchesLoaderImpl", true, (ClassLoader)dexClassLoader);
            try {
                if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)("Got the patcher class " + aClass));
                }
                PatchesLoader loader = (PatchesLoader)aClass.newInstance();
                if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)("Got the patcher instance " + loader));
                }
                String[] getPatchedClasses = (String[])aClass.getDeclaredMethod("getPatchedClasses", new Class[0]).invoke((Object)loader, new Object[0]);
                if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)"Got the list of classes ");
                    for (String getPatchedClass : getPatchedClasses) {
                        Log.i((String)"fd", (String)("class " + getPatchedClass));
                    }
                }
                if (!loader.load()) {
                    updateMode = 3;
                }
            }
            catch (Exception e) {
                Log.e((String)"fd", (String)"Couldn't apply code changes", (Throwable)e);
                e.printStackTrace();
                updateMode = 3;
            }
        }
        catch (Throwable e) {
            Log.e((String)"fd", (String)"Couldn't apply code changes", (Throwable)e);
            updateMode = 3;
        }
        return updateMode;
    }

    private void handleColdSwapPatch(@NonNull ApplicationPatch patch) {
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)"Received restart code patch");
        }
        FileManager.writeDexFile(patch.getBytes(), true);
    }

    private void restart(int updateMode, boolean incrementalResources, boolean toast) {
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)("Finished loading changes; update mode =" + updateMode));
        }
        if (updateMode == 0 || updateMode == 1) {
            if (Log.isLoggable((String)"fd", (int)4)) {
                Log.i((String)"fd", (String)"Applying incremental code without restart");
            }
            if (toast) {
                Activity foreground = Restarter.getForegroundActivity((Context)this.mApplication);
                if (foreground != null) {
                    Restarter.showToast(foreground, "Applied code changes without activity restart");
                } else if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)"Couldn't show toast: no activity found");
                }
            }
            return;
        }
        List<Activity> activities = Restarter.getActivities((Context)this.mApplication, false);
        if (incrementalResources && updateMode == 2) {
            File file = FileManager.getExternalResourceFile();
            if (Log.isLoggable((String)"fd", (int)4)) {
                Log.i((String)"fd", (String)("About to update resource file=" + file + ", activities=" + activities));
            }
            if (file != null) {
                String resources = file.getPath();
                MonkeyPatcher.monkeyPatchApplication((Context)this.mApplication, null, null, resources);
                MonkeyPatcher.monkeyPatchExistingResources((Context)this.mApplication, resources, activities);
            } else {
                Log.e((String)"fd", (String)"No resource file found to apply");
                updateMode = 3;
            }
        }
        Activity activity = Restarter.getForegroundActivity((Context)this.mApplication);
        if (updateMode == 2) {
            if (activity != null) {
                if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)"Restarting activity only!");
                }
                boolean handledRestart = false;
                try {
                    Method method = activity.getClass().getMethod("onHandleCodeChange", Long.TYPE);
                    Object result = method.invoke((Object)activity, 0L);
                    if (Log.isLoggable((String)"fd", (int)4)) {
                        Log.i((String)"fd", (String)("Activity " + activity + " provided manual restart method; return " + result));
                    }
                    if (Boolean.TRUE.equals(result)) {
                        handledRestart = true;
                        if (toast) {
                            Restarter.showToast(activity, "Applied changes");
                        }
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (!handledRestart) {
                    if (toast) {
                        Restarter.showToast(activity, "Applied changes, restarted activity");
                    }
                    Restarter.restartActivityOnUiThread(activity);
                }
                return;
            }
            if (Log.isLoggable((String)"fd", (int)4)) {
                Log.i((String)"fd", (String)"No activity found, falling through to do a full app restart");
            }
            updateMode = 3;
        }
        if (updateMode != 3) {
            if (Log.isLoggable((String)"fd", (int)6)) {
                Log.e((String)"fd", (String)("Unexpected update mode: " + updateMode));
            }
            return;
        }
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)"Performing full app restart");
        }
        Restarter.restartApp((Context)this.mApplication, activities, toast);
    }

    private class SocketServerReplyThread
    extends Thread {
        private final LocalSocket mSocket;

        SocketServerReplyThread(LocalSocket socket) {
            this.mSocket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: {
                try {
                    DataInputStream input = new DataInputStream(this.mSocket.getInputStream());
                    DataOutputStream output = new DataOutputStream(this.mSocket.getOutputStream());
                    try {
                        this.handle(input, output);
                    }
                    finally {
                        try {
                            input.close();
                        }
                        catch (IOException ignore) {}
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException e) {
                    if (!Log.isLoggable((String)"fd", (int)4)) break block13;
                    Log.i((String)"fd", (String)"Fatal error receiving messages", (Throwable)e);
                }
            }
        }

        private void handle(DataInputStream input, DataOutputStream output) throws IOException {
            int message;
            long magic = input.readLong();
            if (magic != 890269988L) {
                Log.w((String)"fd", (String)("Unrecognized header format " + Long.toHexString(magic)));
                return;
            }
            int version = input.readInt();
            output.writeInt(4);
            if (version != 4) {
                Log.w((String)"fd", (String)("Mismatched protocol versions; app is using version 4 and tool is using version " + version));
                return;
            }
            block9: while (true) {
                message = input.readInt();
                switch (message) {
                    case 7: {
                        if (Log.isLoggable((String)"fd", (int)4)) {
                            Log.i((String)"fd", (String)"Received EOF from the IDE");
                        }
                        return;
                    }
                    case 2: {
                        boolean active = Restarter.getForegroundActivity((Context)Server.this.mApplication) != null;
                        output.writeBoolean(active);
                        if (!Log.isLoggable((String)"fd", (int)4)) continue block9;
                        Log.i((String)"fd", (String)("Received Ping message from the IDE; returned active = " + active));
                        continue block9;
                    }
                    case 3: {
                        String path = input.readUTF();
                        long size = FileManager.getFileSize(path);
                        output.writeLong(size);
                        if (!Log.isLoggable((String)"fd", (int)4)) continue block9;
                        Log.i((String)"fd", (String)("Received path-exists(" + path + ") from the " + "IDE; returned size=" + size));
                        continue block9;
                    }
                    case 4: {
                        long begin = System.currentTimeMillis();
                        String path = input.readUTF();
                        byte[] checksum = FileManager.getCheckSum(path);
                        if (checksum != null) {
                            output.writeInt(checksum.length);
                            output.write(checksum);
                            if (!Log.isLoggable((String)"fd", (int)4)) continue block9;
                            long end = System.currentTimeMillis();
                            String hash = new BigInteger(1, checksum).toString(16);
                            Log.i((String)"fd", (String)("Received checksum(" + path + ") from the " + "IDE: took " + (end - begin) + "ms to compute " + hash));
                            continue block9;
                        }
                        output.writeInt(0);
                        if (!Log.isLoggable((String)"fd", (int)4)) continue block9;
                        Log.i((String)"fd", (String)("Received checksum(" + path + ") from the " + "IDE: returning <null>"));
                        continue block9;
                    }
                    case 5: {
                        if (!this.authenticate(input)) {
                            return;
                        }
                        Activity activity = Restarter.getForegroundActivity((Context)Server.this.mApplication);
                        if (activity == null) continue block9;
                        if (Log.isLoggable((String)"fd", (int)4)) {
                            Log.i((String)"fd", (String)"Restarting activity per user request");
                        }
                        Restarter.restartActivityOnUiThread(activity);
                        continue block9;
                    }
                    case 1: {
                        if (!this.authenticate(input)) {
                            return;
                        }
                        List<ApplicationPatch> changes = ApplicationPatch.read(input);
                        if (changes == null) continue block9;
                        boolean hasResources = Server.this.hasResources(changes);
                        int updateMode = input.readInt();
                        updateMode = Server.this.handlePatches(changes, hasResources, updateMode);
                        boolean showToast = input.readBoolean();
                        output.writeBoolean(true);
                        Server.this.restart(updateMode, hasResources, showToast);
                        continue block9;
                    }
                    case 6: {
                        String text = input.readUTF();
                        Activity foreground = Restarter.getForegroundActivity((Context)Server.this.mApplication);
                        if (foreground != null) {
                            Restarter.showToast(foreground, text);
                            continue block9;
                        }
                        if (!Log.isLoggable((String)"fd", (int)4)) continue block9;
                        Log.i((String)"fd", (String)("Couldn't show toast (no activity) : " + text));
                        continue block9;
                    }
                }
                break;
            }
            if (Log.isLoggable((String)"fd", (int)6)) {
                Log.e((String)"fd", (String)("Unexpected message type: " + message));
            }
        }

        private boolean authenticate(@NonNull DataInputStream input) throws IOException {
            long token = input.readLong();
            if (token != AppInfo.token) {
                Log.w((String)"fd", (String)("Mismatched identity token from client; received " + token + " and expected " + AppInfo.token));
                mWrongTokenCount++;
                return false;
            }
            return true;
        }
    }

    private class SocketServerThread
    extends Thread {
        private SocketServerThread() {
        }

        @Override
        public void run() {
            block5: {
                try {
                    LocalServerSocket serverSocket;
                    while ((serverSocket = Server.this.mServerSocket) != null) {
                        LocalSocket socket = serverSocket.accept();
                        if (Log.isLoggable((String)"fd", (int)4)) {
                            Log.i((String)"fd", (String)"Received connection from IDE: spawning connection thread");
                        }
                        SocketServerReplyThread socketServerReplyThread = new SocketServerReplyThread(socket);
                        socketServerReplyThread.run();
                        if (mWrongTokenCount <= 50) continue;
                        if (Log.isLoggable((String)"fd", (int)4)) {
                            Log.i((String)"fd", (String)"Stopping server: too many wrong token connections");
                        }
                        Server.this.mServerSocket.close();
                        break;
                    }
                }
                catch (IOException e) {
                    if (!Log.isLoggable((String)"fd", (int)4)) break block5;
                    Log.i((String)"fd", (String)"Fatal error accepting connection on local socket", (Throwable)e);
                }
            }
        }
    }
}

