/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.runtime;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.ArrayMap;
import android.util.Log;
import android.widget.Toast;
import com.android.tools.fd.runtime.MonkeyPatcher;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class Restarter {
    public static void restartActivityOnUiThread(final @NonNull Activity activity) {
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)"Resources updated: notify activities");
                }
                Restarter.updateActivity(activity);
            }
        });
    }

    private static void restartActivity(@NonNull Activity activity) {
        activity.recreate();
    }

    public static void restartApp(@Nullable Context appContext, @NonNull Collection<Activity> knownActivities, boolean toast) {
        if (!knownActivities.isEmpty()) {
            Activity foreground = Restarter.getForegroundActivity(appContext);
            if (foreground != null) {
                if (toast) {
                    Restarter.showToast(foreground, "Restarting app to apply incompatible changes");
                }
                if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)"RESTARTING APP");
                }
                Activity context = foreground;
                Intent intent = new Intent((Context)context, foreground.getClass());
                int intentId = 0;
                PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)intentId, (Intent)intent, (int)0x10000000);
                AlarmManager mgr = (AlarmManager)context.getSystemService("alarm");
                mgr.set(1, System.currentTimeMillis() + 100L, pendingIntent);
                if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)("Scheduling activity " + foreground + " to start after exiting process"));
                }
            } else {
                Restarter.showToast(knownActivities.iterator().next(), "Unable to restart app");
                if (Log.isLoggable((String)"fd", (int)4)) {
                    Log.i((String)"fd", (String)"Couldn't find any foreground activities to restart for resource refresh");
                }
            }
            System.exit(0);
        }
    }

    static void showToast(final @NonNull Activity activity, final @NonNull String text) {
        if (Log.isLoggable((String)"fd", (int)4)) {
            Log.i((String)"fd", (String)("About to show toast for activity " + activity + ": " + text));
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        Context base;
                        Context context = activity.getApplicationContext();
                        if (context instanceof ContextWrapper && (base = ((ContextWrapper)context).getBaseContext()) == null) {
                            if (Log.isLoggable((String)"fd", (int)5)) {
                                Log.w((String)"fd", (String)"Couldn't show toast: no base context");
                            }
                            return;
                        }
                        Toast.makeText((Context)activity, (CharSequence)text, (int)0).show();
                    }
                    catch (Throwable e) {
                        if (!Log.isLoggable((String)"fd", (int)5)) break block4;
                        Log.w((String)"fd", (String)"Couldn't show toast", (Throwable)e);
                    }
                }
            }
        });
    }

    @Nullable
    public static Activity getForegroundActivity(@Nullable Context context) {
        List<Activity> list = Restarter.getActivities(context, true);
        return list.isEmpty() ? null : list.get(0);
    }

    @NonNull
    public static List<Activity> getActivities(@Nullable Context context, boolean foregroundOnly) {
        ArrayList<Activity> list = new ArrayList<Activity>();
        try {
            Collection c;
            HashMap activities;
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = MonkeyPatcher.getActivityThread(context, activityThreadClass);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            Object collection = activitiesField.get(activityThread);
            if (collection instanceof HashMap) {
                activities = (HashMap)collection;
                c = activities.values();
            } else if (Build.VERSION.SDK_INT >= 19 && collection instanceof ArrayMap) {
                activities = (ArrayMap)collection;
                c = activities.values();
            } else {
                return list;
            }
            for (Object activityRecord : c) {
                Class<?> activityRecordClass = activityRecord.getClass();
                if (foregroundOnly) {
                    Field pausedField = activityRecordClass.getDeclaredField("paused");
                    pausedField.setAccessible(true);
                    if (pausedField.getBoolean(activityRecord)) continue;
                }
                Field activityField = activityRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity)activityField.get(activityRecord);
                if (activity == null) continue;
                list.add(activity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return list;
    }

    private static void updateActivity(@NonNull Activity activity) {
        Restarter.restartActivity(activity);
    }
}

