<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			save_data.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.0
	- Description:  Log data into file and send them to remote server
					This code is called every minute by the GM Counter

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Save timestamps for Alarm, failure and GMC update as well as CPM and AVG values
// ----------------------------------------------------------------------
	function updateTimeStamps()
	{
		global $ini_array, $alarm_sent, $failure_sent, $web_update, $CPM_sent, $AVG_sent;

		if ( $ini_array['GMC.MAP']['enable_gmcmap'] ||
			 $ini_array['MAIL']['enable_email'] )
			file_put_contents( FLAGS_FILE, "$alarm_sent;$failure_sent;$web_update;$CPM_sent;$AVG_sent" );
	}


// ----------------------------------------------------------------------
// Update data file on local server if data recording is enabled
// Date is rounded to the full minute
// ----------------------------------------------------------------------
	$text = "";
	if ( $ini_array['GENERAL']['data_recording'] != -1 )
	{
		foreach ( $data_array as $_date => $_value ) 
			$text .= intval( $_date ) . ";" . intval( $_value ) . "\n";
		file_put_contents( $rootdir . "/history/" .  $ini_array['GENERAL']['data_filename'], 
			"$text" . sprintf( "%s;%s\n", (int) ( date( "U" ) / 60 ) * 60, $_GET['CPM'] ) );
	}


// ----------------------------------------------------------------------
// Read timestamps file (flags.txt)
// ----------------------------------------------------------------------
	$web_update = $alarm_sent = $failure_sent = 0;
	if ( file_exists( FLAGS_FILE ) )
		list( $alarm_sent, $failure_sent, $web_update, $CPM_sent, $AVG_sent ) = 
			array_pad( preg_split( "/;/", file_get_contents( FLAGS_FILE, true ) ), 4, null);


// ----------------------------------------------------------------------
// Add new data and send data to remote server GMC.MAP
// Check: if update delay is over, CPM > failure level
// ----------------------------------------------------------------------
// Update remote GMC World Map server according to update delay
	if ( $ini_array['GMC.MAP']['enable_gmcmap'] &&
		 $ini_array['GMC.MAP']['URL'] <> "" &&
		 $ini_array['GMC.MAP']['AID'] <> "" &&
		 $ini_array['GMC.MAP']['GID'] <> "" &&
		 isset( $_GET['CPM'] ) && 
		 isset( $_GET['AVG'] ) && 
		 $_GET['CPM'] >= $ini_array['DEVICE']['failure_level'] &&
		 date( "U" )  >= $web_update + $ini_array['GMC.MAP']['update_delay'] * 60 ) 
	{
		$stt = sprintf( "%s?AID=%s&GID=%s&CPM=%d&ACPM=%3.2f&uSV=%3.2f",
			$ini_array['GMC.MAP']['URL'],
			$ini_array['GMC.MAP']['AID'],
			$ini_array['GMC.MAP']['GID'],
			$_GET['CPM'],
			(float) $_GET['AVG'] * $ini_array['GMC.MAP']['gmc_factor'] / $ini_array['DEVICE']['agm_factor'] ,
			(float) $_GET['CPM'] / $ini_array['DEVICE']['agm_factor'] );
		$headers = get_headers ( $stt );
		print_r( $headers );

		// Update timestamp and values sent
		$web_update = date( "U" );
		$CPM_sent = $_GET['CPM'];
		$AVG_sent = $_GET['AVG'];
		updateTimeStamps();
	}


// ----------------------------------------------------------------------
//Send mail using Gmail
// ----------------------------------------------------------------------
	use PHPMailer\PHPMailer\PHPMailer;
	use PHPMailer\PHPMailer\Exception;

	require( "$rootdir/inc/mail/Exception.php" );
	require( "$rootdir/inc/mail/PHPMailer.php" );
	require( "$rootdir/inc/mail/SMTP.php" );

	$mail = new PHPMailer( true );

	$mail->IsSMTP(); 												// Telling the class to use SMTP
	$mail->SMTPAuth = true; 										// Enable SMTP authentication
	$mail->SMTPSecure = "ssl"; 										// Sets the prefix to the servier
	$mail->Host = $ini_array['MAIL']['host']; 						// Sets GMAIL as the SMTP server
	$mail->Port = $ini_array['MAIL']['port']; 						// Set the SMTP port for the GMAIL server
	$mail->Username = $ini_array['MAIL']['email1']; 				// GMAIL username
	$mail->Password = $ini_array['MAIL']['pwd']; 					// GMAIL password
	$mail->WordWrap = 100; 											// Wrap long text
	$mail->IsHTML(true); 											// Body content is HTML
	$mail->SetFrom( $ini_array['MAIL']['email1'], _AGM_NAME );		// E-mail sender
	$mail->AddReplyTo( $ini_array['MAIL']['email1'], _AGM_NAME );	// Reply e-mail address


	// Radiation level threshold exceeded
	// ----------------------------------------------------------------------
	if ( $ini_array['MAIL']['enable_email'] && 
		 $_GET['CPM'] > $ini_array['DEVICE']['alarm_level'] )
	{
		// Send e-mails (once a day only)
		if ( date( "U" ) >= $alarm_sent + 86400 )
		{
			$level = (float) $_GET['CPM'] / $ini_array['DEVICE']['agm_factor'];
			$mail->Subject 	= _EMAIL_SUBJECT;
			$mail->Body 	= _EMAIL_ALARM . "<b style='color: " . Level_Color( $level ) . "'>" .
				sprintf( "<b> %3.2f uSv/h </b> ", $level ) 
				. "</b> [" . $ini_array['GENERAL']['location'] . "]<br />" 
				. _EMAIL_REMINDER . "<br />&nbsp;<br />"
				. Reminder_Message();

			if ( $ini_array['MAIL']['email1'] <> "" )
			{
				$mail->AddAddress( $ini_array['MAIL']['email1'], "A-GM Admin" );
				$mail->Send();
			}
			if ( $ini_array['MAIL']['email2'] <> "" )
			{
				$mail->AddAddress( $ini_array['MAIL']['email2'], "A-GM e-mail #2" );
				$mail->Send();
			}
			if ( $ini_array['MAIL']['email3'] <> "" )
			{
				$mail->AddAddress( $ini_array['MAIL']['email3'], "A-GM e-mail #3" );
				$mail->Send();
			}
			if ( $ini_array['MAIL']['email4'] <> "" )
			{
				$mail->AddAddress( $ini_array['MAIL']['email4'], "A-GM e-mail #4" );
				$mail->Send();
			}
			if ( $ini_array['MAIL']['email5'] <> "" )
			{
				$mail->AddAddress( $ini_array['MAIL']['email5'], "A-GM e-mail #5" );
				$mail->Send();
			}

			// Update timestamps to set flag delay
			$alarm_sent = date( "U" );
			updateTimeStamps();
		} 
	}


	// Radiation level is abnormal
	// ----------------------------------------------------------------------
	if ( $ini_array['MAIL']['enable_email'] && 
		 $_GET['CPM'] < $ini_array['DEVICE']['failure_level'] )
	{
		if ( date( "U" ) >= $failure_sent + 86400 )
		{
			$mail->Subject 	= _EMAIL_ERROR;
			$mail->Body 	= _EMAIL_FAILURE . 
				sprintf( "<b> %3.2f uSv/h </b> ", (float) $_GET['CPM'] / $ini_array['DEVICE']['agm_factor'] ) 
				. " [" . $ini_array['GENERAL']['location'] . "]<br />"
				. _EMAIL_REMINDER;

			if ( $ini_array['MAIL']['email1'] <> "" )
			{
				$mail->AddAddress( $ini_array['MAIL']['email1'], "A-GM Admin" );
				$mail->Send();
			}

			// Update timestamps to set flag delay and enable next failure e-mail in 24 hours only
			$failure_sent = date( "U" );
			updateTimeStamps();
		}
	}

?>
