<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			read_ini.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- version:		1.0
	- Description:  Geiger-Muller Counter page functions

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Edit XML files (thuylnt @ php.net modifies by AdNovea)
// ----------------------------------------------------------------------
    function beginsWith( $str, $sub ) { return ( substr( $str, 0, strlen( $sub ) ) === $sub ); }

	function read_ini_file( $f, &$r )
	{
		$null 			= ""; 
		$r				= $null; 
		$first_char 	= ""; 
		$sec			= $null; 
		$num_comments 	= "0"; 
		$num_newline 	= "0";
		$comment_chars 	= ";#";		// Characters used for coments
	
		//Read to end of file with the newlines still attached into $f
		$f = @file( $f );
		if ( $f === false ) 
			return -2;

		// Process all lines from 0 to count($f)
		for ( $i = 0; $i < @count( $f ); $i++ ) 
		{
			$w = @trim( $f[$i] );
			$first_char = @substr( $w, 0, 1 );
			if ( $w ) 
			{
				if ( ( @substr( $w, 0, 1) == "[" ) and ( @substr( $w, -1, 1 ) ) == "]" ) 
				{
					$sec = @substr( $w, 1, @strlen($w) - 2 );
					$num_comments = 0; $num_newline = 0;
				}
				else if ( ( stristr( $comment_chars, $first_char) == true ) ) 
				{
					$r[$sec]["Comment_".$num_comments] = $w;
					$num_comments = $num_comments + 1;
				}               
				else 
				{	// Look for the = char to allow us to split the section into key and value
					$w = @explode( "=", $w ); 
					$k = @trim( $w[0] ); 
					unset( $w[0] ); 
					$v = @trim( @implode( "=", $w ) );
					// Comment to keep quotes around string
					// if ( ( @substr( $v, 0, 1) == "\"" ) and ( @substr( $v, -1, 1 ) == "\"" ) )  $v = @substr( $v, 1, @strlen( $v ) - 2 );
					$r[$sec][$k] = $v;
				}
			}
			else 
			{
				$r[$sec]["Newline_".$num_newline] = $w; 
				$num_newline = $num_newline + 1;
			}
		}
		return 1;
	}

	function write_ini_file( $path, $assoc_arr ) 
	{
		global $debug, $HTML_content;
		$content = "";

		foreach ( $assoc_arr as $key=>$elem ) 
		{
			if ( is_array( $elem ) ) 
			{
				if ( $key != '' ) 
					$content .= "[".$key."]\r\n";                   
				foreach ( $elem as $key2=>$elem2 ) 
				{
					if ( beginsWith( $key2, 'Comment_' ) == 1 && beginsWith( $elem2, ';' ) ) 
						$content .= $elem2 . "\r\n";
					else if ( beginsWith( $key2, 'Newline_' ) == 1 && ( $elem2 == '' ) )
						$content .= $elem2 . "\r\n";
					else if ( beginsWith( $elem2, ';' ) )  
						$content .= ";" . $key2 . " = " . substr( $elem2, 1 ) . "\r\n";
					else 
						$content .= $key2 . " = " . $elem2 . "\r\n";
				}
			}
			else 
				$content .= $key . " = " . $elem . "\r\n";
		}
		if ( !$handle = fopen( $path, 'w' ) ) 
			return -2;

		$tmp = fwrite( $handle, $content );

		if ( $debug ) 
			$HTML_content .= "<br>Write " . basename($path) . " = $tmp";
		fclose( $handle );

		if ( !$tmp ) 
			return -2; 
		else 
			return 1;
	}


// ----------------------------------------------------------------------
// Read INI configuration file or create file with default if missing
// ----------------------------------------------------------------------
	$ini_array = array();
	if ( file_exists( INIFILE ) ) 
		read_ini_file( INIFILE, $ini_array ); 
	else
		read_ini_file( INIFILE . ".default", $ini_array );

	if ( write_ini_file( INIFILE, $ini_array )== -2 ) 
			$HTML_content .= "ERROR writing agm.ini<br>";


?>