<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			read_file.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.0
	- Description:  Read log file data and manage Moving window/Auto-save modes

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Read INI file sections, keys and values
// ----------------------------------------------------------------------
	$stt = @file_get_contents( "$rootdir/history/$data_file" );
	if ( $stt != "" )
	{
		$datafile_avg = 0;
		$datafile_max = 0;
		$datafile_last = 0;
		$i = 0;
		$fdata = explode( "\n", $stt );
		$data_array = array();
		
		// Read first data to get the oldest date-time
		list( $l_date, $l_value ) = array_pad( preg_split( "/;/", $fdata[0] ), 2, null);
		$timefile_first = intval( $l_date );


		// MANAGE MONTHLY SAVE
		// Save data if Monthly mode is enabled, current data file is selected and 1st data's month ≠ current month
		// ----------------------------------------------------------------------
		if ( $data_file == $ini_array['GENERAL']['data_filename'] )
		{
			if ( $ini_array['GENERAL']['data_recording'] == 1 &&
				 date( 'Ym', date("U") ) != date( 'Ym', $timefile_first ) )
			{
				// Copy last month data into CSV file
				if ( !copy( $rootdir . "/history/" . $ini_array['GENERAL']['data_filename'], "history/AGM_" . date( 'Y-m', $timefile_first ) . ".csv" ) ) 
				{
					$HTML_content .= "<br />ERROR saving last month history log in to CSV file!";
					return;
				}
				else
					$oldest = strtotime( date( 'Y-m-01', date("U") ) );		// Set oldest valide data for deletion process

				// Continue reading the data file to get Max and Avg values
				$datafile_max = intval( $l_value );
				$datafile_avg = $datafile_max;
				$i = 1;

				foreach ( $fdata as $line ) 
				{
					list( $l_date, $l_value ) = array_pad( preg_split( "/;/", $line ), 2, null);
					if ( intval( $l_date ) < $oldest )						// Look into previous month data
					{
						if ( intval( $l_value  ) > $datafile_max ) 			// New max CPM
							$datafile_max = $l_value;
						$datafile_avg += $l_value;							// Sum data for average CPM value
						$i++;
					}
				}

				$datafile_avg /= $i;										// Normalize the average value

				// Update history file with new entry added at the beginning
				$text = file_get_contents( $rootdir . "/history/history.txt" );
				file_put_contents( $rootdir . "/history/history.txt", 
				sprintf("%d;%d;%3.2f\n", $timefile_first, $datafile_max, $datafile_avg ) . $text );

			}
			else
				// Compute date for old entries > 90 days
				$oldest = intval (date("U")) - $ini_array['GENERAL']['data_retention'] * 24 * 60 * 60;
		}
		else
			$oldest = 0;													// Keep all data from monthly files

		// UPDATE DATA LOG FILE
		// Fill $data_array with time and CPM, get max and lastest values
		// ----------------------------------------------------------------------
		$data_array = array();
		$datafile_avg = 0;
		$datafile_max = 0;
		$datafile_last = 0;
		$i = 0;

		foreach ( $fdata as $line) 
		{
			list( $l_date, $l_value ) = array_pad( preg_split( "/;/", $line ), 2, null);

			if ( intval( $l_date ) > $oldest )								// Keep data within retention period
			{
				$data_array[ $l_date ] = $l_value;							// Create array entry

				if ( $i == 0 ) $timefile_first = $l_date;					// New start file date

				if ( intval( $l_value  ) > $datafile_max ) 					// New max CPM
				{
					$timefile_max = $l_date;
					$datafile_max = $l_value;
				}

				$timefile_last = $l_date;									// Last read time
				$datafile_last = $l_value;									// Last read value
				$datafile_avg += $l_value;									// Sum data for average CPM value

				$i++;
			}
		}

		if ( $i > 0 ) $datafile_avg /= $i;									// Normalize the average value

	}

?>