<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			params.php
	- Project:		A-GM Managger
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.1
	- Description:  Parameters file

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Debug mode 
// ----------------------------------------------------------------------
	global $debug;														// Debugging mode
	$debug = false;														// (set to false for production)
	if ( $debug ) { ini_set("display_errors",1); error_reporting(E_ALL); }


// ----------------------------------------------------------------------
// Defines, Constantes and Variables
// ----------------------------------------------------------------------
	define( "AGM_VERSION", "1.1" );									// A-GM version
	define( "INIFILE", "$rootdir/settings/agm.ini" ) ;					// INI configuration file name

	// Thresholds
	define( "THRESHOLD_1",  0.2 );										// Radiation below level in µSv/h - normal
	define( "THRESHOLD_2",  0.5 );										// Radiation below level in µSv/h - warning / find out
	define( "THRESHOLD_3",  1.0 ); 									// Radiation below level in µSv/h - potential danger / find out and leave area
	define( "THRESHOLD_4",  6.5 );										// Radiation below level in µSv/h - critical / leave area ASAP
	define( "THRESHOLD_5",  13 );										// Radiation below level in µSv/h - emergengy / immediate evacuation
	// Above THRESHOLD_5												// Radiation above level in µSv/h - extreme / immediate evacuation
	// Thresholds color W/o Alpha
	define( "TH1_RGB", "#00CC00" );
	define( "TH2_RGB", "#AAFFAA" );
	define( "TH3_RGB", "#FFAA00" );
	define( "TH4_RGB", "#FF8888" );
	define( "TH5_RGB", "#FF0000" );
	define( "TH6_RGB", "#CC00FF" );
	// Thresholds color with Alpha
	define( "TH1_RGBA", 'rgba(   0, 204,   0, 0.1)' );
	define( "TH2_RGBA", 'rgba( 170, 255, 170, 0.1)' );
	define( "TH3_RGBA", 'rgba( 255, 128,   0, 0.1)' );
	define( "TH4_RGBA", 'rgba( 255, 128, 128, 0.1)' );
	define( "TH5_RGBA", 'rgba( 255,   0,   0, 0.1)' );
	define( "TH6_RGBA", 'rgba( 204,   0, 255, 0.1)' );

	// File names
	define( "HISTORY_FILE", "$rootdir/history/history.txt" );			// File stores the monthly backup list
	define( "FLAGS_FILE",   "$rootdir/history/last.txt" );				// File stores last GMC.MAP update; last email sent date, last email failure date

	define( "_DOCTYPE", "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"
\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");

	global $data_file;													// File name of data used in graphic plot charts
	global $ini_array;													// INI configuration file parameters
	global $HTML_content;												// HTML page content
	global $timefile_first;											// Date of first sample into file
	global $timefile_last;												// Date of last sample into file
	global $datafile_last;												// Value of Lastest sample in CPM from data file 
	global $timefile_max;												// Date of Max sample into file
	global $datafile_max;												// Value of Max sample in CPM from data file
	global $datafile_avg;												// Value of Average samples in CPM from data file
	global $data_array;												// Data organized as an array
	global $CPM_sent;													// Last CPM value sent to GMC.MAP
	global $AVG_sent;													// Last Average calue sent to GMC.MAP

	global $nb_X_ticks;												// Nb of X divisions

	global $AGM_URL;
	$AGM_URL = "agm.php";												// URL PHP file

?>
