<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			page_table.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.0
	- Description:  Display logged data into a table

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Draw HTML page content
// ----------------------------------------------------------------------

// Display the current and max value
	if ( $last_measure < THRESHOLD_1 ) $Scolor="lightgreen";
	elseif ( $last_measure < THRESHOLD_2 ) $Scolor="yellow";
	elseif ( $last_measure < THRESHOLD_3 ) $Scolor="orange";
	else $Scolor="red";
	$HTML_content .=  "<h1><span style='color:$Scolor; display:inline'>" . sprintf( _CURRENT . " %01.3f µSv/h &nbsp; &nbsp; &nbsp; </span>", $last_measure );
	if ( $max_value < THRESHOLD_1 ) $Scolor="lightgreen";
	elseif ( $max_value < THRESHOLD_2 ) $Scolor="yellow";
	elseif ( $max_value < THRESHOLD_3 ) $Scolor="orange";
	else $Scolor="red";
	$HTML_content .= sprintf( "<span style='color:$Scolor; display:inline'>" . _MAX . " %01.3f µSv/h", $max_value ) . "</span></h1>";

// Display the table of data
	$HTML_content .= "
	<!-- Data list -->
	<table width=500 class='text2'>
	<tr align=center bgcolor=darkgray>
		<td width=150>" . _UTC_DATE_TIME . "</td><td width=100>CPM</td><td width=100>µSv</td><td width=150>" . _AVERAGE. "</td>
		</tr>\n
		$table
	</table><br>";

?>