<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			page_home.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.0
	- Description:  Home page

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Menu
// ----------------------------------------------------------------------
	load_language( "home" );											// Load translations from home section

	$current_value = (float) $datafile_last / (float) $ini_array['DEVICE']['agm_factor'];	// In µSv/h
	$average_value = (float) $datafile_avg  / (float) $ini_array['DEVICE']['agm_factor'];	// In µSv/h
	$maximum_value = (float) $datafile_max  / (float) $ini_array['DEVICE']['agm_factor'];	// In µSv/h
//"
	$HTML_content .= "
	<div class='container_page' name='home'>

	<!-- CURRENT LEVEL -->
		<div class='container_title'>
			<div class='label'>" . _RADIATIONS. "</div>
			<div class='value' style='color: " . Level_Color( $current_value ) . ";' >" . sprintf( "%3.2f µSv/h", $current_value ) . "</div>
		</div>

	<!-- CURRENT DATA -->
		<div class='container_text'>
			<div class='label'>" . _UPDATED . " &nbsp; </div>
			<div class='value'>" . _COUNTER_CPM . " <b>" . $datafile_last . " CPM</b><br />"
			. _DATE_ON . " ". "<a href='$AGM_URL?page=graphics&l=0' data-ajax='false'>"  
			. date( _DATE_TIME24_FORMAT, $timefile_last ) . "</a><br/>&nbsp;</div>
		</div>

	<!-- MAX DATA -->
		<div class='container_text'>
			<div class='label'>" 
			. _DATA_MAX. " " . (int)( ($timefile_last - $timefile_first) / 86400 ) . " " . _DAYS . " &nbsp; </div>
			<div class='value'>"
			. _MAX_VALUE . " <b style='color: " . Level_Color( $maximum_value ) . ";'>" 
			. sprintf( "%3.2f µSv/h", $maximum_value ) . 
			"</b> - <b>$datafile_max CPM</b><br />" 
			. _DATE_ON . " ". "<a href='$AGM_URL?page=graphics&l=1&s=" . ( $timefile_max - 1800 ) . "' data-ajax='false'>"  
			. date( _DATE_TIME24_FORMAT, $timefile_max ) 
			. "</a><br /><br />" 
			.  _AVERAGE_VALUE . " <b style='color: " . Level_Color( $average_value ) . ";'>" 
			. sprintf( "%3.2f µSv/h", $average_value ) . "</b>"
			. sprintf( " - <b>%.2f CPM</b><br />&nbsp;", $datafile_avg ) 
			. "</div>
		</div>

	<!-- LOCATION -->
		<div class='container_text'>
			<div class='label'>";

		if ( $ini_array['GENERAL']['location'] <> "") 
			$HTML_content .= _LOCATION . " &nbsp; </div>
			<div class='value'>" . $ini_array['GENERAL']['location'];

		$HTML_content .=  "
			</div>
		</div>

	</div>
	";

?>
