<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			page_download.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.2
	- Description:  Download the data file

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Menu
// ----------------------------------------------------------------------
	load_language( "history" );												// Load translations from Donwload section

// If not logged
	if ( !isset( $_SESSION['valid'] ) || ( $_SESSION['valid'] == false ) ) 
	{
		$HTML_content .= Message( _NO_LOGIN, true) ;
		return;
	}

	// Current data
	$d_max = sprintf( "%3.2f", (float) $datafile_max / (float) $ini_array['DEVICE']['agm_factor'] );
	$d_avg = sprintf( "%3.2f", (float) $datafile_avg / (float) $ini_array['DEVICE']['agm_factor'] );

	$HTML_content .= "
<div class='container_page'>
	<h1 class='config_title'><b>" . _HISTORY_TITLE . "</b></h1><br/>

	<div class='container_history'>
		<div class='history_data' style='width: 300px;'>
			<div class='history_month' style='width: 200px;'>
			<a href='?page=graphics&l=1' data-ajax='false'>" . _DATA_FILE . "</a></div>
			<div class='history_max'>" . _HISTORY_MAX . "<span style='color: " . Level_Color( $d_max ) . ";'> $d_max</span></div>
			<div class='history_avg'>" . _HISTORY_AVG . "<span style='color: " . Level_Color( $d_avg ) . ";'> $d_avg</span></div>
		</div>";	


	// Read "history.txt" file to retrieve for each recorded month theirs Date/Max/Avg values
	$l_year = 0;
	if ( file_exists( HISTORY_FILE ) &&
		( $fp = fopen( HISTORY_FILE, "r" ) ) !== FALSE )
	{
		while ( !feof( $fp ) )
		{
			list( $l_date, $l_max, $l_avg ) = array_pad( preg_split( "/;/", fgets( $fp ) ), 3, null);
			if ( $l_date == 0 ) continue;								// Ignore empty line

			$l_month = date( "m", intval( $l_date ) );
			if ( date( "Y", intval( $l_date ) ) != $l_year )
			{
				$l_year = date( "Y", intval( $l_date ) );
				$HTML_content .= "<div class='clear'></div><br />
					<div class='history_year'><b>$l_year</b></div>
					<div class='clear'></div>";

			}
			$d_max = sprintf( "%3.2f", $l_max / (float) $ini_array['DEVICE']['agm_factor'] );
			$d_avg = sprintf( "%3.2f", $l_avg / (float) $ini_array['DEVICE']['agm_factor'] );

			// Display month entry only if the corresponding file exists
			if ( file_exists( "history/AGM_$l_year-$l_month.csv" ) )
				$HTML_content .= "
			<div class='history_data'>
				<div class='history_month'>
				<a href='?page=graphics&l=1&f=$l_year-$l_month' data-ajax='false'>$l_month</a></div>
				<div class='history_max'>" . _HISTORY_MAX . "<span style='color: " . Level_Color( $d_max ) . ";'> $d_max</span></div>
				<div class='history_avg'>" . _HISTORY_AVG . "<span style='color: " . Level_Color( $d_avg ) . ";'> $d_avg</span></div>
			</div>";
		}
		fclose( $fp );
	}

	$HTML_content .= "
		</div>
	</div>";

?>
