<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			page_graphics.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- version:		1.0
	- Description:  Plot the data charts

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );

	// Invalid menu if not logged
	if ( !isset( $_SESSION['valid'] ) && $_GET['l']  > 0 ) 
	{
		$HTML_content .= Message( _NO_LOGIN, true) ;
		return;
	}


// ----------------------------------------------------------------------
// Draw HTML page content
// ----------------------------------------------------------------------
	load_language( "graphics" );										// Load translations from Graphics section

	$data_chart = "";
	$arr_pos = 0;
	$time_pos;

	// Under sample data according to time span
	switch ( isset ( $_GET['l'] ) ? $_GET['l'] : 0 ) 
	{
		// 1 hour  =    60 measures - plot points every 1 minute => 60 pts
		case 1:	
			$samples = 60;												// Nb of seconds for this plot
			$step = 60;													// Takes every sample
			$label= _1_HOUR;
			$nb_X_ticks = 6;											// Nb of major divs
			$mode = 1;													// Mode #
			break;	
 
		// 6 hours =   360 measures - plot points every 1 minute=> 360 pts
		case 2: 
			$samples = 360;
			$step = 60;													// Takes every sample
			$label= _6_HOURS;
			$nb_X_ticks = 6;
			$mode = 2;
			break;	

		// 1 day   =  1440 measures - plot points every 1 minute => 1440 pts
		case 3:
			$samples = 1440;
			$step = 60;													// Takes every sample
			$label= _24_HOURS; 
			$nb_X_ticks = 6;
			$mode = 3;
			break;				

		// 1 week  = 10080 measures - plot points every 7 minutes => 1440 pts
		case 4:
			$samples = 10080;
			$step = 420;												// Average one sample over 7 minutes
			$label= _1_WEEK;
			$nb_X_ticks = 7;
			$mode = 4;
			break;			

		// 4 weeks = 40320 measures - plot points every 28 minutes => 1440 pts
		case 5:
			$samples = 40320;
			$step = 1680;												// Average one sample over 28 minutes
			$label= _4_WEEKS;
			$nb_X_ticks = 4;
			$mode = 5;
			break;	

		// Real time  - plot points every 1 mins
		default:
			$samples = 60;
			$step = 60;
			$label= _REAL_TIME;
			$nb_X_ticks = 6;
			$mode = 0;
			$timefile_last = date( "U" );
			break;
	}

	// Get start time position. If not set : current data -> last measure, previous month -> first measure
	if ( isset( $_GET['f'] ) )
		$start_time =  ( !isset ( $_GET['s'] )  || $_GET['s'] == "" ? $timefile_first : $_GET['s'] );
	else
		$start_time =  ( !isset ( $_GET['s'] )  || $_GET['s'] == "" ? $timefile_last : $_GET['s'] );

	// Jump buttons management
	$start_time += ( isset( $_POST[ 'NEXT' ] ) ? $samples * 60 : 0 );
	$start_time -= ( isset( $_POST[ 'PREV' ] ) ? $samples * 60 : 0 );

	// Ensure start/end time position along with actual positions. End max position is last data + 10mins
	$start_time  = ( $start_time < $timefile_first ? $timefile_first : $start_time );
	$norm_time = ( $start_time + $samples * 60 > $timefile_last ? $timefile_last - ( $samples - 10 )* 60: $start_time );

	// Set the start position to the next rounded 10 mins slot and update end position
	$start_time = (int) ($norm_time / 600 ) * 600;

	// Compute the end time position along with the zoom factor
	$end_time = $start_time + $samples * 60;
	$_SESSION['starttime'] = $start_time;
	$time_pos = $start_time;

	$data_chart_last = 0;
	for ( $i = $start_time; $i < $start_time + $samples * 60; $i += $step )
	{
		// Create data points
		if ( $data_chart == "") $data_chart = "["; else $data_chart .= ",[";
		$data_chart .= $i * 1000 . ",";

		// Subsample data values
		$k = 0;
		$tmp_val = 0;
		for ( $j = 0; $j < $step / 60; $j++ )
			if ( isset( $data_array[$i + $j][1] ) )
			{
				$tmp_val += $data_array[$i + $j];
				$k++;
			}

		// Add existing data samples otherwise repeat last value (except for samples in the future)
		if ( $k > 0 ) $data_chart_last = (float) $tmp_val / $k / $ini_array['DEVICE']['agm_factor'];
		if ( $i > date( "U" ) ) $data_chart_last = 0;
		$data_chart .= sprintf( "%3.2f", $data_chart_last ). "]";
	}
	
	$HTML_content .="
<!-- For Plot -->
	<script type='text/javascript' src='plugins/jquery.jqplot.js'></script>
	<script type='text/javascript' src='plugins/jqplot.barRenderer.js'></script>
	<script type='text/javascript' src='plugins/jqplot.highlighter.js'></script>
	<script type='text/javascript' src='plugins/jqplot.cursor.js'></script>
	<script type='text/javascript' src='plugins/jqplot.pointLabels.js'></script>
	<script type='text/javascript' src='plugins/jqplot.dateAxisRenderer.js'></script>
	<script type='text/javascript' src='plugins/jqplot.canvasTextRenderer.js'></script>
	<script type='text/javascript' src='plugins/jqplot.canvasAxisTickRenderer.js'></script>

<!-- For horizontal lines -->
	<script type='text/javascript' src='plugins/jqplot.canvasOverlay.js'></script>

<!-- For colored rectangles -->
	<script type='text/javascript' src='plugins/jqplot.canvasAxisLabelRenderer.js'></script>

<!-- See date format at https://github.com/phstc/jquery-dateFormat -->
	<script type='text/javascript' src='js/dateFormat.min.js'></script>

	<!-- pre class='code prettyprint brush: js'></pre -->

	<div  name='plotchart'>

		<!-- Plot header-->
		<div class='container_title'>
			<h1 class='plotheader'>";

	// Set title along with the displayed data
	if ( $data_file != $ini_array['GENERAL']['data_filename'] )
		$HTML_content .= "[ " . basename( str_replace( ".csv", "", str_replace( "AGM_", "", $data_file ) ) ) . " ]";
	else
		$HTML_content .= _GRAPH_TITLE;

	$HTML_content .= " $label</h1>

			<!-- Plot chart-->
			<div id='chart1'></div>

			<!-- Time position, Buttons & Slider -->
	";

//'$AGM_URL?page=graphics&l=xxxxx&s=yyyyy&f=tttt

	// Show time slider for all graphics but the realtime plot
	if ( isset ( $_GET['l'] ) && $_GET['l'] != 0 ) 
		$HTML_content .="
			<form id='plotForm' action='$AGM_URL?page=graphics&l=$mode&s=$start_time&f=$data_file' method='post' accept-charset='UTF-8'>
				<div class='ui-bar'>
					<a href='$AGM_URL?page=graphics&l=$mode&s=" . ( $start_time - $samples * 60 ) 
			. ( isset( $_GET['f'] ) ? "&f=" . $_GET['f'] : "" ) .
					"' data-ajax='false' class='ui-btn ui-btn-left ui-icon-carat-l ui-btn-icon-notext ui-corner-all'></a>
					<div class='plotlabel'>" . date ( _SLIDER_DATE_PHP, $start_time) . "</div>
					<a href='$AGM_URL?page=graphics&l=$mode&s=" . ( $start_time + $samples * 60 ) 
			. ( isset( $_GET['f'] ) ? "&f=" . $_GET['f'] : "" ) .
					"' data-ajax='false' class='ui-btn ui-btn-right ui-icon-carat-r ui-btn-icon-notext ui-corner-all'></a>
				</div>
			</form>
			<form id='plotForm'>
				<div id='plotTime' class='time-slider'>
					<input class='ui-hidden-accessible' name='sliderTime' id='sliderTime' type='range' min='$timefile_first' max='$timefile_last' value='$start_time' />
				</div>
			</form>
	";

	else
		$HTML_content .="
			<div class='ui-bar'>
				<div class='plotlabel'>" . _UPDATED . " &nbsp; " . date ( _SLIDER_DATE_PHP, $timefile_last ) . "</div>
			</div>
			<div id='plotForm'><div id='plotTime' class='time-slider'><div id='sliderTime'>&nbsp;</div></div></div>
	";

	$HTML_content .="
		</div><!-- End of container_title -->
	</div><!-- End of plotchart -->

	<script class='code' type='text/javascript'>

		// Resize plot with browser size
		function rePlot()
		{
			// Available height to draw plot chart
			screen =     $.mobile.getScreenHeight();
			header =     $( '.ui-header'  ).hasClass( 'ui-header-fixed' ) ? $( '.ui-header' ).outerHeight() - 1 : $( '.ui-header' ).outerHeight();
			footer =     $( '.ui-footer'  ).hasClass( 'ui-footer-fixed' ) ? $( '.ui-footer' ).outerHeight() - 1 : $( '.ui-footer' ).outerHeight();
			plotheader = $( '.plotheader' ).outerHeight();
			plotlabel =  $( '.plotlabel'   ).outerHeight();
			timeSlider = $( '.time-slider' ).outerHeight();
			curContent = $( '.ui-content'  ).outerHeight() - $( '.ui-content' ).height();
			newHeight  = screen - header - footer - plotheader - plotlabel - timeSlider - curContent - 50;
			if ( newHeight < 350 ) newHeight = 350;
			$( '#chart1' ).height( newHeight );
			plot1.replot( {} );	// Redraw
		}

		// Sliding cursor
		$( '.time-slider' ).change( function( event ) {
			var pos = new Date( ~~( event.target.value  / 600) * 600000 ); 
			$( '.plotlabel' ).text( DateFormat.format.date( pos , '" . _SLIDER_DATE . "') );
		});


		// Leave sliding
		$( '.time-slider' ).on( 'slidestop touchend', function( ) { 
			window.location = '$AGM_URL?page=graphics&l=" . $_GET['l'] . "&s=' + ~~( $('#sliderTime').val() / 600) * 600"
		. ( isset( $_GET['f'] ) ? "+ '&f=" . $_GET['f'] . "'" : "" ) . "; 
		});


		// Execute on browser resizing or screen rotate
		$( window ).resize( function() { rePlot() });


		// Executes when the HTML document is loaded
		$( document ).ready( function () 
		{


		// Variables: Chart value series
			var screen =     $.mobile.getScreenHeight();
			var header =     $( '.ui-header'  ).hasClass( 'ui-header-fixed' ) ? $( '.ui-header' ).outerHeight() - 1 : $( '.ui-header' ).outerHeight();
			var footer =     $( '.ui-footer'  ).hasClass( 'ui-footer-fixed' ) ? $( '.ui-footer' ).outerHeight() - 1 : $( '.ui-footer' ).outerHeight();
			var plotheader = $( '.plotheader' ).outerHeight();
			var plotlabel =  $( '.plotlabel'   ).outerHeight();
			var timeSlider = $( '.time-slider' ).outerHeight();
			var curContent = $( '.ui-content'  ).outerHeight() - $( '.ui-content' ).height();
			var newHeight  = screen - header - footer - plotheader - plotlabel - timeSlider - curContent - 50;
			if ( newHeight < 350 ) newHeight = 350;

			var s1 = [$data_chart];
			var s2 = [";


	// Show MAX value marker if within the plot window
	if ( $timefile_max  > $start_time && $timefile_max  < $end_time ) 
		$HTML_content .= 
			"[" .( $timefile_max * 1000 ) .", " . ( $datafile_max / $ini_array['DEVICE']['agm_factor'] ) . "]";
	
	$HTML_content .="];


		// Plot chart
			plot1 = $.jqplot( 
				'chart1', 
				[s1, s2], 
				{
					height: newHeight,
					title: { 
						text: '" . _RADIATIONS . " (µSv/h) " . ( $step > 60 ? " " . _AVERAGED : "" ) ."',
						fontSize: '12pt',
						color: $('h1').css('color'),
					},
					axes: {
						xaxis:{
							color: $('h1').css('color'),
							renderer: $.jqplot.DateAxisRenderer,
							tickDistribution: 'µSv/h',
	// comment to allow newline	on ticks					tickRenderer: $.jqplot.CanvasAxisTickRenderer,
							numberTicks: $nb_X_ticks,
							tickOptions: {
								angle: 0,
								fontFamily: 'Arial',
								fontSize: '9pt',
								formatString: '" . _CHART_DATE2 . "', 
								textColor: $('h1').css('color'),
							},
						},
						yaxis:{
							min: 0,
							max: " .  ceil ( $datafile_max / $ini_array['DEVICE']['agm_factor'] ) . ",
							//tickInterval: 0.05,
							label: '', // µSv/h
							labelOptions: {textColor: $('h1').css('color') },
							color: $('h1').css('color'),
							min: 0.0,
							tickDistribution: 'UTC',
							rendererOptions: { forceTickAt0: true },
							tickOptions: { 
								fontSize: '9pt',
								textColor: $('h1').css('color'),
								formatString: '%3.2f',
							}
						}
					},    
					// Config plot line
					series: [
						{
							color: '#4444AA',
							lineWidth: 2,
							shadow: true,
							showMarker: false,
						},
						{
							color: '#FF8800',
							lineWidth: 0,
							markerOptions: {
								show: true,
								size: 15,
							}
						}
					],
					grid: {
						background: '#FFFFFF', 
					},
					// Data tooltip
					highlighter: {
						show: true,
						sizeAdjust: 7.5,
						tooltipLocation: 'ne',
						formatString: '%s<br /> %3.2f µSv/h',
					},
					// Zoom
					cursor:{ 
						show: true,
						zoom:true, 
						showTooltip:false
					},
					// Draw MAX, AVG, ALARM lines and 6 colored areas
					canvasOverlay: {
						show: true,
						objects: [
							{horizontalLine: {
								name: 'average',
								y: " . ( $datafile_avg / $ini_array['DEVICE']['agm_factor'] ) . ",
								lineWidth: 2,
								color: 'rgb( 92, 92, 255 )',
								shadow: false,
								lineCap: 'butt',
								xOffset: 0,
								showTooltip: true,
								tooltipLocation: 'n',
								tooltipFormatString: '" . sprintf( _LINE_AVG ." - %3.2f µSv/h", $datafile_avg / $ini_array['DEVICE']['agm_factor'] ) . "',
							}},
							{dashedHorizontalLine: {
								name: 'max',
								y: " . ( $datafile_max / $ini_array['DEVICE']['agm_factor'] ) . ",
								lineWidth: 2,
								dashPattern: [4,8],
								lineCap: 'round',
								xOffset: '0',
								color: 'rgb( 255, 0, 0 )',
								shadow: false,
								showTooltip: true,
								tooltipLocation: 'n',
								tooltipFormatString: '" . sprintf( _LINE_MAX ." - %3.2f µSv/h", $datafile_max / $ini_array['DEVICE']['agm_factor'] ) . "',
							}},
							{dashedHorizontalLine: {
								name: 'alarm',
								y: " . ( $ini_array['DEVICE']['alarm_level'] / $ini_array['DEVICE']['agm_factor'] ) . ",
								lineWidth: 1,
								dashPattern: [24,8],
								lineCap: 'round',
								xOffset: '0',
								color: 'rgb( 0, 0, 0 )',
								shadow: false,
								showTooltip: true,
								tooltipLocation: 'n',
								tooltipFormatString: '" . sprintf( _LINE_ALARM ." - %3.2f µSv/h", $ini_array['DEVICE']['alarm_level'] / $ini_array['DEVICE']['agm_factor'] ) . "',
							}},

							{ rectangle: { 
								ymin: 0, 
								ymax: 0.2, 
								xminOffset: '0px',  
								xmaxOffset: '0px',  
								yminOffset: '0px',  
								ymaxOffset: '0px',
								color: '" . TH1_RGBA . "',  
								showTooltip: true,  
								tooltipFormatString: '" . _TH_NORMAL. "' 
							}},
							{ rectangle: { 
								ymin: 0.2,  
								ymax: 0.5,  
								xminOffset: '0px',  
								xmaxOffset: '0px',  
								yminOffset: '0px',  
								ymaxOffset: '0px',
								color: '" . TH2_RGBA . "',  
								showTooltip: true,  
								tooltipFormatString: '" . _TH_SAFE. "' 
							}},
							{ rectangle: { 
								ymin: 0.5,  
								ymax: 1.0,  
								xminOffset: '0px',  
								xmaxOffset: '0px',  
								yminOffset: '0px', 
								 ymaxOffset: '0px',
								color: '" . TH3_RGBA . "',  
								showTooltip: true,  
								tooltipFormatString: '" . _TH_WARNING. "' 
							}},
							{ rectangle: { 
								ymin: 1.0,  
								ymax: 6.5,  
								xminOffset: '0px',  
								xmaxOffset: '0px',  
								yminOffset: '0px',  
								ymaxOffset: '0px',
								color: '" . TH4_RGBA . "',  
								showTooltip: true,  
								tooltipFormatString: '" . _TH_HIGH. "' 
							}},
							{ rectangle: { 
								ymin: 6.5,  
								ymax: 13.0,  
								xminOffset: '0px',  
								xmaxOffset: '0px',  
								yminOffset: '0px',  
								ymaxOffset: '0px',
								color: '" . TH5_RGBA . "',  
								showTooltip: true,  
								tooltipFormatString: '" . _TH_CRITICAL. "' 
							}},
							{ rectangle: { 
								ymin: 13.0,  
								xminOffset: '0px',  
								xmaxOffset: '0px',  
								yminOffset: '0px',  
								ymaxOffset: '0px',
								color: '" . TH6_RGBA . "',  
								showTooltip: true,  
								tooltipFormatString: '" . _TH_EXTREME. "' 
							}},
						]
					}
				}
			);


		});

	</script>";

?>