<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			page_config.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.0
	- Description:  Configuration page

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Menu
// ----------------------------------------------------------------------
	load_language( "config" );											// Load translations from Config section

	$error_net = false;

// If not logged
	if ( !isset( $_SESSION['valid'] ) || ( $_SESSION['valid'] == false ) ) 
	{
		$HTML_content .= Message( _NO_LOGIN, true) ;
		return;
	}

// Process Counter remote control instant buttons
	if ( $ini_array['DEVICE']['counter_ip'] != "" )
	{
		$GMC_URL = "http://" . $ini_array['DEVICE']['counter_ip'];  // A-GM Counter device IP
		$GMC_CMD = "";

		// RESET
		if ( isset( $_POST[ 'RESET' ] ) )  $error_net |= !@file_get_contents( "$GMC_URL/?RESET" );

		// BUZZER
		if ( isset( $_POST[ 'BUZZER' ] ) ) $error_net |= !@file_get_contents( "$GMC_URL/?BEEP=" . $_POST[ 'BUZZER' ] );

		// LCD ON-OFF
		if ( isset( $_POST[ 'LCD' ] ) )    $error_net |= !@file_get_contents( "$GMC_URL/?LCD=" . $_POST[ 'LCD' ] );

		// SAVE to EEPROM
		if ( isset( $_POST[ 'SAVE' ] ) )   $error_net |= !@file_get_contents( "$GMC_URL/?SAVE" );
	}

	// Delete all data from retention file
	if ( isset( $_POST['erase'] ) && isset( $_POST['deletion'] ) && $_POST['deletion'] == '1' )
	{
		if ( unlink( "$rootdir/" . $ini_array['GENERAL']['data_filename'] ) ) 
			$HTML_content .= Message( _ERASED, false );
		else
			$HTML_content .=  Message( _ERROR_INI, true ); 
		return;
	}

	// Process and Save new configuration
	if ( isset( $_POST['save'] ) )
	{
		$ini_array['GENERAL']['lang'] 			= $_POST['lang'];
		$ini_array['GENERAL']['skin_theme'] 	= $_POST['skin_theme'];
		$ini_array['GENERAL']['location'] 		= $_POST['location'];
		$ini_array['GENERAL']['timezone'] 		= $_POST['timezone'];
		$ini_array['GENERAL']['data_recording'] = $_POST['data_recording'];
		$ini_array['GENERAL']['data_retention'] = $_POST['data_retention'];
		$ini_array['GENERAL']['data_filename'] 	= $_POST['data_filename'];

		$ini_array['GENERAL']['username'] 		= $_POST['username'];
		$ini_array['GENERAL']['password'] 		= $_POST['password'];

		$ini_array['GMC.MAP']['enable_gmcmap'] 	= $_POST['enable_gmcmap'];
		$ini_array['GMC.MAP']['URL'] 			= $_POST['URL'];
		$ini_array['GMC.MAP']['AID'] 			= $_POST['AID'];
		$ini_array['GMC.MAP']['GID'] 			= $_POST['GID'];
		$ini_array['GMC.MAP']['update_delay'] 	= $_POST['update_delay'];
		$ini_array['GMC.MAP']['gmc_factor'] 	= $_POST['gmc_factor'];

		$ini_array['DEVICE']['agm_factor'] 		= $_POST['agm_factor'];
		$ini_array['DEVICE']['alarm_level'] 	= $_POST['alarm_level'];
		$ini_array['DEVICE']['failure_level'] 	= $_POST['failure_level'];
		$ini_array['DEVICE']['counter_ip'] 		= $_POST['counter_ip'];
		$ini_array['DEVICE']['server_ip'] 		= $_POST['server_ip'];

		$ini_array['MAIL']['enable_email'] 		= $_POST['enable_email'];
		$ini_array['MAIL']['host'] 				= $_POST['host'];
		$ini_array['MAIL']['port'] 				= $_POST['port'];
		$ini_array['MAIL']['email1'] 			= $_POST['email1'];
		$ini_array['MAIL']['pwd'] 				= $_POST['pwd'];
		$ini_array['MAIL']['email2'] 			= $_POST['email2'];
		$ini_array['MAIL']['email3'] 			= $_POST['email3'];
		$ini_array['MAIL']['email4'] 			= $_POST['email4'];
		$ini_array['MAIL']['email5'] 			= $_POST['email5'];

		// Avoid empty of out of range duration
		if ( intval( $ini_array['GENERAL']['data_retention'] ) > 90 ||
			 intval( $ini_array['GENERAL']['data_retention'] ) < 1) $ini_array['GENERAL']['data_retention'] = 90;

		// Send parameter values to device
		if ( $ini_array['DEVICE']['counter_ip'] != "" )
		{
			$GMC_URL = "http://" . $ini_array['DEVICE']['counter_ip'];  // A-GM Counter device IP
			$error_net |= !@file_get_contents( $GMC_URL . "/?ALARM="  . $_POST['alarm_level'] );
			$error_net |= !@file_get_contents( $GMC_URL . "/?FACTOR=" . $_POST['agm_factor'] );
			$error_net |= !@file_get_contents( $GMC_URL . "/?SERVER=" . $_POST['server_ip'] );
		}

		// Save new configuration
		if ( write_ini_file( INIFILE, $ini_array ) == -2 ) 
			$HTML_content .= Message( _ERROR_INI, true );
		else
			$HTML_content .= Message( _SAVED, false ); 

	}

	// Retreive GM Counter information
	if ( $ini_array['DEVICE']['counter_ip'] != "" )
	{
		$stt =  @file_get_contents( "$GMC_URL/?JSON" ) ;
		if ( $stt != "" )
		{
			$arr = (array) json_decode( $stt , true );
			$stt = "";
			foreach ( $arr["data"] as $key => $value ) 
					$stt .= "$key : $value\n";
			$stt .= "\n";
			foreach ( $arr["params"] as $key => $value ) 
				if ( is_array( $value ) ) 
					foreach ( $arr["params"][$key] as $key1 => $value1 ) $stt .= "$key1 : $value1\n";
				else 
					$stt .= "$key : $value\n";
		}
	}

	// Display error message - cannot connect to device
	if ( $error_net ) 
			$HTML_content .= Message( _ERROR_NET, true );

	// Selected tab
	$tab1 = ( isset( $_GET[ 'tabs' ] ) && $_GET[ 'tabs' ] == "1" ? "block" : "none" );
	$tab2 = ( isset( $_GET[ 'tabs' ] ) && $_GET[ 'tabs' ] == "2" ? "block" : "none" ); 
	$tab3 = ( isset( $_GET[ 'tabs' ] ) && $_GET[ 'tabs' ] == "3" ? "block" : "none" ); 
	$tab4 = ( isset( $_GET[ 'tabs' ] ) && $_GET[ 'tabs' ] == "4" ? "block" : "none" ); 
	$tab5 = ( isset( $_GET[ 'tabs' ] ) && $_GET[ 'tabs' ] == "5" ? "block" : "none" ); 
	$tab6 = ( isset( $_GET[ 'tabs' ] ) && $_GET[ 'tabs' ] == "6" ? "block" : "none" ); 


	$HTML_content .= "
<!-- AGM COUNTER STATUS -->
	<div data-role='popup' id='popupInfo' class='ui-content' style='width: 300px' option='align: 100,200'>
		<a href='#' data-rel='back' class='ui-btn ui-corner-all ui-shadow ui-btn-a ui-icon-delete ui-btn-icon-notext ui-btn-right'></a>
		<h1>" . _OPTIONS . "</h1>
		<pre>" . (  $stt == "" ? _ERROR_NET : $stt ) . "</pre>
	</div>


	<form name='configForm' action='#' data-ajax='false' method='post' accept-charset='UTF-8'>
	<div class='container_page' id='config'>
	<h1 class='config_title'>" . _CONFIGURATION . "</h1>";


	$HTML_content .= "
<!--
// GENERAL
-->

	<div id='tabs-1' class='ui-boy-d ui-content' style='display: $tab1;'>
			<h1 class='title'><b>" . _GENERAL_INTERFACE . "</b></h1>

<!-- LANGUAGE -->
		<div class='container_text'>
			<div class='params'>" . _LANGUAGE . "</div>
			<div class='data'><select name='lang' data-mini='true'>
				<option value='en'" . ($ini_array['GENERAL']['lang'] == 'en' ? " selected" : "" ) . ">English</option>
				<option value='fr'" . ($ini_array['GENERAL']['lang'] == 'fr' ? " selected" : "" ) . ">Français</option>
				<option value='cn'" . ($ini_array['GENERAL']['lang'] == 'cn' ? " selected" : "" ) . ">繁体中文</option>
				<option value='jp'" . ($ini_array['GENERAL']['lang'] == 'jp' ? " selected" : "" ) . ">日本語</option>
				<option value='ru'" . ($ini_array['GENERAL']['lang'] == 'ru' ? " selected" : "" ) . ">Pусский</option>
			</select></div>
		</div>

<!-- THEME -->
		<div class='container_text'>
			<div class='params'>" . _THEME . "</div>
			<div class='data'>
				<fieldset data-role='controlgroup' data-type='horizontal'>
					<label><input type='radio' class='ui-btn-inline ui-corner-all' data-mini='true' data-theme='a' id='skin_theme' name='skin_theme' value='a' " . ( $ini_array['GENERAL']['skin_theme'] == "a" ? "checked": "" ) . "/>". "A" . "</label>
					<label><input type='radio' class='ui-btn-inline ui-corner-all' data-mini='true' data-theme='b' id='skin_theme' name='skin_theme' value='b' " . ( $ini_array['GENERAL']['skin_theme'] == "b" ? "checked": "" ) . "/>". "B" . "</label>
					<label><input type='radio' class='ui-btn-inline ui-corner-all' data-mini='true' data-theme='c' id='skin_theme' name='skin_theme' value='c' " . ( $ini_array['GENERAL']['skin_theme'] == "c" ? "checked": "" ) . "/>". "C" . "</label>
				</fieldset>
			</div>
		</div>
	

<!-- LOCATION -->
		<div class='container_text'>
			<div class='params'>" . _LOCATION . "</div>
			<div class='data'><input  class='ui-corner-all ui-mini' name='location' value='" 
			. $ini_array['GENERAL']['location'] . "' placeholder='" . _LOC_POS. "'  type='text'></div>
		</div>

<!-- TIMEZONE -->
		
		<div class='container_text'>
			<div class='params'>" . _TIMEZONE . " &nbsp; " . _TIMEZONE_URL. "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='timezone' value='" 
			. $ini_array['GENERAL']['timezone'] . "' required/></div>

			<h1 class='title'><b>" . _GENERAL_DATA . "</b></h1>
		</div>

<!-- RETENTION PERIOD -->
		<div class='container_text'>
				<div class='params'>" . _DATA_FILENAME . "</div>
				<div class='data'><input class='ui-corner-all ui-mini' type='text' name='data_filename' value='" . $ini_array['GENERAL']['data_filename'] . "' required/></div>
			<div class='params'>" . _RECORD_MODE . "</div>
			<div class='data'> 
				<fieldset data-role='controlgroup' data-type='horizontal'>
				<label><input class='ui-btn-inline ui-corner-all' data-mini='true' type='radio' name='data_recording' value='0' " . ( $ini_array['GENERAL']['data_recording'] == 0 ? "checked": "" ) . "/>
				" . _MOVING . "</label>
				<label><input class='ui-btn-inline ui-corner-all' data-mini='true' type='radio' name='data_recording' value='1' " . ( $ini_array['GENERAL']['data_recording'] == 1 ? "checked": "" ) . "/>
				" . _AUTO_SAVE . "</label>
				<label><input class='ui-btn-inline ui-corner-all' data-mini='true' type='radio' name='data_recording' value='-1' " . ( $ini_array['GENERAL']['data_recording'] == -1 ? "checked": "" ) . "/>
				" . _PAUSE . "</label>
				</fieldset>
			</div>
			<div class='params'>" . _RETENTION . "</div>
			<div class='data'>
				<input type='text' name='data_retention' data-mini='true' value='" . 
					$ini_array['GENERAL']['data_retention'] . "' />
			</div>
		</div>

<!-- ERASE RETENTION PERIOD -->
		<div class='container_text'>
			<div class='params'>" . _DATA_ERASE . "</div>
			<div class='data'><button class='ui-btn ui-btn-inline ui-icon-delete ui-btn-icon-left ui-corner-all ui-mini' type='submit' name='erase' id='erase'>" . _ERASE . "</button></div>
			<div class='params'>" . _BOX_ERASE . "</div>
			<div class='data'><select name='deletion' id='deletion' data-mini='true' data-role='flipswitch'>
				<option value='0'>" . _NO. "</option>
				<option value='1'>" . _YES . "</option>
			</select></div>
		</div>

	</div><!-- End Tab-1 -->


<!--
// A-GM COUNTER REMOTE CONTROL
-->

	<div id='tabs-2' class='ui-boy-d ui-content' style='display: $tab2;'>
		<div style='display: $tab2;'></div>
		<h1 class='title'><b>" . _REMOTE_CONTROL . "</b></h1>

<!-- RESET -->
		<div class='container_text'>
			<div class='params'>" . _RESET_COUNTERS . "</div>
			<div class='data'><button class='ui-btn ui-btn-inline ui-icon-delete ui-btn-icon-left ui-corner-all ui-mini' type='submit' name='RESET'>" . _RESET . "</button></div>
			<br />
		</div>

<!-- BUZZER -->
		<div class='container_text'>
			<div class='params'>" . _BUZZER_CTRL . "</div>
			<div class='data'> 
				<button class='ui-btn ui-btn-inline ui-icon-check  ui-btn-icon-left ui-corner-all ui-mini' type='submit' name='BUZZER' value='ON'>" . _ON . "</button> &nbsp; 
				<button class='ui-btn ui-btn-inline ui-icon-delete ui-btn-icon-left ui-corner-all ui-mini' type='submit' name='BUZZER' value='OFF'>" . _OFF . "</button>
			</div>
		</div>
		<br />

<!-- LCD -->
		<div class='container_text'>
			<div class='params'>" . _LCD_ONOFF . "</div>
			<div class='data'> 
				<button class='ui-btn ui-btn-inline ui-icon-check  ui-btn-icon-left ui-corner-all ui-mini' type='submit' name='LCD' value='ON'>" . _ON . "</button> &nbsp; 
				<button class='ui-btn ui-btn-inline ui-icon-delete ui-btn-icon-left ui-corner-all ui-mini' type='submit' name='LCD' value='OFF'>" . _OFF . "</button>
			</div>
		</div>
		<br />

<!-- OPTIONS -->
		<div class='container_text'>
			<div class='params'>" . _OPTIONS . "</div>
			<div class='data'> 
				<a href='#popupInfo' data-rel='popup' class='ui-btn ui-btn-inline ui-icon-eye  ui-btn-icon-left ui-corner-all ui-mini' data-position-to='window'>" . _SHOW . "</a>
<!-- 				<input type='submit' name='OPTIONS' value='" . _SHOW . "'>  -->
			</div>
		</div>

	</div><!-- End Tab-2 -->


<!--
// A-GM COUNTER 
-->

	<div id='tabs-3' class='ui-boy-d ui-content' style='display: $tab3;'>

		<h1 class='title'><b>" . _NETWORK_PARAMS . "</b></h1>

<!-- A-GM ALARM THRESHOLD -->
		
		<div class='container_text'>
			<div class='params'>" . _LEVEL . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='alarm_level' value='" . $ini_array['DEVICE']['alarm_level'] . "' required/></div>
		</div>

<!-- A-GM FACTOR -->
		
		<div class='container_text'>
			<div class='params'>" . _FACTOR . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='agm_factor' value='" . $ini_array['DEVICE']['agm_factor'] . "' required/></div>
		</div>
		

<!-- IP ADDRESSES -->

		<div class='container_text'>
			<div class='params'>" . _DEVICE_IP . "</div>
			<div class='data'> 
				<input type='text' class='ui-corner-all ui-mini' name='counter_ip' placeholder='' value='" . $ini_array['DEVICE']['counter_ip']. "' autocomplete='off' pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$' />
			</div>
		
			<div class='params'>" . _SERVER_IP . "</div>
			<div class='data'> 
				<input type='text' class='ui-corner-all ui-mini' name='server_ip' placeholder='xxx.xxx.xxx.xxx' value='" . $ini_array['DEVICE']['server_ip']. "' autocomplete='off' pattern='^([0-9]{1,3}\.){3}[0-9]{1,3}$' required/>
			</div>
		</div>

<!-- SAVE TO EEPROM -->
		<div class='container_text'>
			<div class='params'>" . _SAVE_EEPROM. "</div>
			<div class='data'> 
				<button class='ui-btn ui-btn-inline ui-icon-check ui-btn-icon-left ui-corner-all ui-mini' type='submit' name='SAVE'>" . _OK . "</button>
			</div>
		</div>

<!-- A-GM FAILURE THRESHOLD -->
		<h1 class='title'><b>" . _DEVICE_FAILURE . "</b></h1>
		
		<div class='container_text'>
			<div class='params'>" . _THRESHOLD . "</div>
			<div class='data'><input class='ui-corner-all ui-mini'type='text' name='failure_level' value='" . $ini_array['DEVICE']['failure_level'] . "' required/></div>
		</div>
		
	</div><!-- End Tab-3 -->


<!--
// GMC.MAP UPDATE 
-->

	<div id='tabs-4' class='ui-boy-d ui-content' style='display: $tab4;'>

		<h1 class='title'><b>" . _GMC_ACCOUNT . "</b></h1>

<!-- ENABLE GMC.MAP UPDATES -->
		<div class='container_text'>
			<div class='params'>" . _ENABLE_GMCMAP . "</div>
			<div class='data'><select name='enable_gmcmap' id='enable_gmcmap' data-mini='true' data-role='flipswitch'>
				<option value='0' " . ( $ini_array['GMC.MAP']['enable_gmcmap'] ? "" : "selected" ) . ">" . _NO. "</option>
				<option value='1' " . ( $ini_array['GMC.MAP']['enable_gmcmap'] ? "selected" : "" ) . ">" . _YES . "</option>
			</select></div>
		</div>
		
<!-- GMC.MAP URL -->
		<div class='container_text'>
			<div class='params'>" . _URL . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='URL' value='" . $ini_array['GMC.MAP']['URL'] . "'/></div>
		</div>

<!-- USER ACCOUNT -->
		
		<div class='container_text'>
			<div class='params'>" . _AID . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='AID' value='" . $ini_array['GMC.MAP']['AID'] . "'/></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _GID . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='GID' value='" . $ini_array['GMC.MAP']['GID'] . "'/></div>
		</div>

		<h1 class='title'><b>" . _GMC_PARAMS . "</b></h1>

<!-- REFRESH DELAY -->
		
		<div class='container_text'>
			<div class='params'>" . _DELAY . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='update_delay' value='" . $ini_array['GMC.MAP']['update_delay'] . "' required/></div>
		</div>

<!-- GMC.MAP CONVERSION FACTOR -->
		
		<div class='container_text'>
			<div class='params'>" . _FACTOR . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='gmc_factor' value='" . $ini_array['GMC.MAP']['gmc_factor'] . "' required/></div>
		</div>

	</div><!-- End Tab-4 -->


<!--
// MAILS
-->

	<div id='tabs-5' class='ui-boy-d ui-content' style='display: $tab5;'>

			<h1 class='title'><b>" . _SECTION_MAIL . "</b></h1>
		
<!-- ENABLE E-MAIL SENDING -->
		<div class='container_text'>
			<div class='params'>" . _ENABLE_EMAIL . "</div>
			<div class='data'><select name='enable_email' id='enable_email' data-mini='true' data-role='flipswitch'>
				<option value='0' " . ( $ini_array['MAIL']['enable_email'] ? "" : "selected" ) . ">" . _NO. "</option>
				<option value='1' " . ( $ini_array['MAIL']['enable_email'] ? "selected" : "" ) . ">" . _YES . "</option>
			</select></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _HOST . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='host' value='" . $ini_array['MAIL']['host'] . "' placeholder='" . _HOST_PLACEHOLDER. "'/></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _PORT. "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='port' value='" . $ini_array['MAIL']['port'] . "' placeholder='" . _PORT_PLACEHOLDER. "'/></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _EMAIL1 . "</div>
			<div class='data'><input class='corner-all ui-mini' type='text' name='email1' value='" . $ini_array['MAIL']['email1'] . "' placeholder='" . _EMAIL1_PLACEHOLDER. "'/></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _PWD . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='password' name='pwd' value='" . $ini_array['MAIL']['pwd'] . "' placeholder='" . _PWD_PLACEHOLDER. "'/></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _EMAIL . " #2</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='email2' value='" . $ini_array['MAIL']['email2'] . "' placeholder='" . _EMAIL_PLACEHOLDER. "'/></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _EMAIL . " #3</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='email3' value='" . $ini_array['MAIL']['email3'] . "' placeholder='" . _EMAIL_PLACEHOLDER. "'/></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _EMAIL . " #4</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='email4' value='" . $ini_array['MAIL']['email4'] . "' placeholder='" . _EMAIL_PLACEHOLDER. "'/></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _EMAIL . " #5</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='email5' value='" . $ini_array['MAIL']['email5'] . "' placeholder='" . _EMAIL_PLACEHOLDER. "'/></div>
		</div>
				
	</div><!-- End Tab-5 -->


<!--
// LOGIN
-->

	<div id='tabs-6' class='ui-boy-d ui-content' style='display: $tab6;'>
		
			<h1 class='title'><b>" . _SECTION_LOGIN . "</b></h1>

		<div class='container_text'>
			<div class='params'>" . _USER . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='text' name='username' value='" . $ini_array['GENERAL']['username'] . "' required/></div>
		</div>
		
		<div class='container_text'>
			<div class='params'>" . _PASSWORD . "</div>
			<div class='data'><input class='ui-corner-all ui-mini' type='password' name='password' value='" . $ini_array['GENERAL']['password'] . "' required/></div>
		</div>
		
	</div><!-- End Tab-6 -->
	";

// Display SAVE button
	if ( isset( $_GET[ 'tabs' ] ) && $_GET[ 'tabs' ] != "2" )
		$HTML_content .= "
<!--
// SAVE PARAMS
-->		<center>
			<button class='ui-btn ui-btn-inline ui-icon-check ui-btn-icon-left ui-corner-all' data-ajax='false' type='submit' name='save'>" . _SAVE . "</button>
		</center>";

	$HTML_content .= "
	</form>
	</div>
";

?>