<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			page.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.0
	- Description:  Handle HTM pages

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


/// ----------------------------------------------------------------------
// CONSTANTES & VARIABLES, INCLUDES
// ----------------------------------------------------------------------
	$username = $password = $userError = $passError = '';


// ----------------------------------------------------------------------
// Draw HTML page
// ----------------------------------------------------------------------
	$_SESSION['page'] = (isset($_GET['page'])?$_GET['page']:'home');

	$HTML_content = _DOCTYPE . "\n 
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
	<title>" . _TITLE . "</title>";

	// Auto-refresh home page and Graphic RT every minute
	if ( $_SESSION['page'] == "home" || ( isset( $_GET['l'] ) && $_GET['l'] == "0" ) )	
		$HTML_content .= "
	<meta http-equiv='refresh' content='60' />";

	$HTML_content .= "
	<meta http-equiv='Content-Type' content='text/html; charset='" . $languages[$lang]['locale'] . "' />
	<meta http-equiv='X-UA-Compatible' content='IE=edge,chrome=1' />
	<meta name='viewport' content='width=device-width, initial-scale=1, user-scalable=no' />

	<meta http-equiv='cache-control' content='no-cache' /> 		<!-- tells browser not to cache -->
	<meta http-equiv='expires' content='0' /> 						<!-- says that the cache expires 'now' -->
	<meta http-equiv='pragma' content='no-cache' /> 				<!-- says not to use cached stuff, if there is any -->

	<link rel='shortcut icon' href='images/favicon.ico' type='image/x-icon' />
	<link rel='icon' href='images/favicon.png' type='image/png' />

	<script src='js/jquery.js'></script>
	<script src='js/jquery.mobile-1.4.5.min.js'></script>

	<script class='code' type='text/javascript'>
		// Select Theme (default:a=white, b=black, c=A-GM custom css, d=default html)
		$.mobile.page.prototype.options.theme = '" . $ini_array['GENERAL']['skin_theme'] . "';

		// Prevent ENTER to send form
		function disableSubmit() { $('input,select').keypress(function(event) { 
			if ( event.keyCode == 13 ) $('input,select').blur();
			return event.keyCode != 13; 
		});	}
		$(document).bind('pageinit', function () { disableSubmit(); });

	</script>

	<link rel='stylesheet' href='css/themes/default/A-GM.min.css' />
	<link rel='stylesheet' href='css/themes/default/jquery.mobile.icons.min.css' />
	<link rel='stylesheet' href='css/themes/default/jquery.mobile.structure-1.4.5.min.css' />
	<link rel='stylesheet' type='text/css' href='css/jquery.jqplot.css' />
	<link rel='stylesheet' type='text/css' href='css/styles.css' />

</head>
<body>
<div data-role='page' id='page'>
	";

// Banner and menu
	include( "$rootdir/inc/menu.php");

	$HTML_content .= "
	<div role='main' id='main' class='ui-content jqm-content jqm-fullwidth'>
	";

// Display page
	switch ($_SESSION['page']) 
	{
		case 'graphics':
			if ( isset( $data_array ) ) include( "$rootdir/inc/page_graphics.php" ); 
				else $HTML_content .= Message( _NO_DATA, true ); break;

		case 'history':
			include( "$rootdir/inc/page_history.php" ); break;

		case 'config':
			include( "$rootdir/inc/page_config.php" ); break;

		case 'about':
			include( "$rootdir/inc/page_about.php" ); break;

		default:
			include( "$rootdir/inc/page_home.php" );
	}


// Display page and add footer
	 $HTML_content .= "
	</div><!-- End of Main role -->

	<div data-role='footer' data-position='fixed'>
		<div class='footer' align='center'><b>"._AGM_NAME . "&nbsp;v" . AGM_VERSION ."</b> "._FOOTER."</div>";


// Remind/Clean installation test file
	if ( isset( $_GET[ 'REMOVE' ] ) ) unlink( "$rootdir/test.php" ) ;
	if ( file_exists( "$rootdir/test.php" ) )
	$HTML_content .= "
<!-- FOOTER -->
		<center>
		<span style='color: pink; font: 10pt Arial;'><b>IMPORTANT:</b> Check the 
		<a target='phpinfo' href='/A-GM/test.php'>server params</a> and <a href='$AGM_URL?REMOVE'>remove</a>
		the file once your A-GM installation is completed.</span>
		</center>";


// Close HTML page
	$HTML_content .=  "
	</div><!-- End of Footer -->

</div><!-- End of Page role -->

</body>
</html>";

// Draw HTML page
	echo $HTML_content;

?>