<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			menu.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.0
	- Description:  Page menu

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Menu
// ----------------------------------------------------------------------
	load_language( "menu" );											// Load translations from Menu section

	//$stt = ( isset( $_SESSION['starttime'] ) ? "&s=" . $_SESSION['starttime'] : ""); 
	$stt  = ( isset( $_GET['s'] ) ? "&s=" . $_GET['s'] : ""); 
	$stt .= ( isset( $_GET['f'] ) ? "&f=" . $_GET['f'] : ""); 


// ----------------------------------------------------------------------
// SESSION and LOGIN
// ---------------------------------------------------------------------- 
	// Login
	if ( isset( $_POST['login'] ) )
	{
		if ( $_POST['username'] == $ini_array['GENERAL']['username'] && 
			 $_POST['password'] == $ini_array['GENERAL']['password'] )
		{
			$_SESSION['valid'] = true;
		}
	}
	else
	{
	// Logout
		if ( isset( $_GET['logout'] ) )
			unset( $_SESSION['valid'] );
	}


// ----------------------------------------------------------------------
// Draw menu
// ----------------------------------------------------------------------
	$HTML_content .= "

<!-- HEADER -->
		<div data-role='header' style='overflow:hidden;'>
			<h1 style='margin-left: 0; margin-right: 0;'><img src='images/web_logo.png' alt='' border='0' style='margin: -8px 20px;'>" . _TITLE. "</h1>
			<a href='#nav-panel' data-icon='bars' data-iconpos='notext'>Menu</a>
			<a href=" . ( isset( $_SESSION['valid'] ) ? "'$AGM_URL?logout' data-ajax='false'" : "'#login-form'" ) 
			. " data-icon='" . ( isset( $_SESSION['valid'] ) ? "unlock" : "lock" ) . "' data-iconpos='notext'>" . _LOGIN . "</a>
		</div> <!-- Header -->

<!-- PANEL Menu -->
		<div data-role='panel' data-display='push' id='nav-panel'>

			<ul data-role='listview' data-inset='true'>
				<li data-icon='home'><a href='$AGM_URL?page=home' data-ajax='false'>" .	 _HOME . "</a></li>

				<li data-role='collapsible' data-iconpos='right' data-inset='false' data-icon='eye'>
					<h2>" . _DATA . "</h2>
					<ul data-role='listview'>
						<li><a href='$AGM_URL?page=graphics&l=0'     data-ajax='false'> &nbsp; &nbsp; " . _GRAPHICS . "</a></li>";

	// If logged, show Detail graphics, History, Download, Configuration and Help menu entries
	if ( isset( $_SESSION['valid'] ) )
	{
		$HTML_content .= "
						<li><a href='$AGM_URL?page=graphics&l=1$stt' data-ajax='false'> &nbsp; &nbsp; " . _1_HOUR .   "</a></li>
						<li><a href='$AGM_URL?page=graphics&l=2$stt' data-ajax='false'> &nbsp; &nbsp; " . _6_HOURS .  "</a></li>
						<li><a href='$AGM_URL?page=graphics&l=3$stt' data-ajax='false'> &nbsp; &nbsp; " . _24_HOURS . "</a></li>
						<li><a href='$AGM_URL?page=graphics&l=4$stt' data-ajax='false'> &nbsp; &nbsp; " . _1_WEEK.    "</a></li>
						<li><a href='$AGM_URL?page=graphics&l=5$stt' data-ajax='false'> &nbsp; &nbsp; " . _4_WEEKS . "</a></li>
						<li><a href='$AGM_URL?page=history' data-ajax='false'> &nbsp; &nbsp; " . _HISTORY. "</a></li>
						<li><a href='history/$data_file' data-ajax='false' download> &nbsp; &nbsp; " . _DOWNLOAD. "</a></li>
					</ul>
				</li>
				<li data-role='collapsible' data-iconpos='right' data-inset='false' data-icon='gear'>
					<h2>" . _CONFIGURATION . "</h2>
					<ul data-role='listview'>
						<li><a href='$AGM_URL?page=config&tabs=1' data-ajax='false'> &nbsp; &nbsp; " . _SECTION_GENERAL .	"</a></li>";

		// Disable REMOTE CTRL menu entry for none C-GM Counter device (no IP¨address)
		if ( $ini_array['DEVICE']['counter_ip'] != "" )
			$HTML_content .= "
						<li><a href='$AGM_URL?page=config&tabs=2' data-ajax='false'> &nbsp; &nbsp; " . _SECTION_REMOTE .   	"</a></li>";

		$HTML_content .= "
						<li><a href='$AGM_URL?page=config&tabs=3' data-ajax='false'> &nbsp; &nbsp; " . _SECTION_COUNTER .  	"</a></li>
						<li><a href='$AGM_URL?page=config&tabs=4' data-ajax='false'> &nbsp; &nbsp; " . _SECTION_GMCMAP . 	"</a></li>
						<li><a href='$AGM_URL?page=config&tabs=5' data-ajax='false'> &nbsp; &nbsp; " . _SECTION_MAIL.    	"</a></li>
						<li><a href='$AGM_URL?page=config&tabs=6' data-ajax='false'> &nbsp; &nbsp; " . _SECTION_LOGIN . 	"</a></li>
					</ul>
				</li>
				<li data-icon='info'><a href='help/A-GM.pdf' target='_help' data-ajax='false'>" . _HELP. "</a></li>";
	}
	else
		$HTML_content .= "
					</ul>
				</li>";

	$HTML_content .= "
				<li data-icon='comment'><a href='$AGM_URL?page=about' data-ajax='false'>" . _ABOUT. "</a></li>";
	
	// Add Logout menu entry
	if ( isset( $_SESSION['valid'] ) )
	$HTML_content .= "
				<li data-icon='lock'><a href='$AGM_URL?logout' data-ajax='false'>" . _LOGOUT . "</a></li>";

	$HTML_content .= "
			</ul><!-- Main Menu -->
		</div><!-- /panel -->
	";


	// If not logged, allow the Login dialog
	if ( !isset( $_SESSION['valid'] ) )
		$HTML_content .= "

<!-- LOGIN Panel menu -->
		<div data-role='panel' data-position='right' data-display='reveal' id='login-form'>
			<form id='loginForm' action='#' data-ajax='false' method='post' accept-charset='UTF-8'>
				<h2>" . _SIGN_IN . "</h2>
				<label for='username' class='ui-hidden-accessible'></label>
				<input name='username' id='username' value='' placeholder='" . _LOGIN_NAME . "'  data-clear-btn='true' data-mini='true' type='text' required>
				<label for='password' class='ui-hidden-accessible'></label>
				<input name='password' id='password' value='' placeholder='" . _LOGIN_PWD . "' data-clear-btn='true' autocomplete='off' data-mini='true' type='password' required>
				<button type='submit' name='login' id='login' class='ui-btn ui-corner-all ui-shadow ui-btn-b ui-btn-icon-left ui-icon-check'>" . _OK . "</button>
			</form>
		</div>";

?>
