<?php
/************************************************************************
	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			languages.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- version:		1.0
	- Description:  Keep track of available languages

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// ----------------------------------------------------------------------
// Defines, Constantes and Variables
// ----------------------------------------------------------------------
	global $languages, $lang, $ini_array;

	$languages['en'] = Array(
		"id"			=> "en",
		"name"			=> "English",
		"path"			=> "en_US",
		"locale"		=> "en_US");
		
	$languages['fr'] = Array(
		"id"			=> "fr",
		"name"			=> "Français",
		"path"			=> "fr_FR",
		"locale"		=> "fr_FR.utf-8");

	$languages['cn'] = Array(
		"id"			=> "zh",
		"name"			=> "繁体中文",
		"path"			=> "zh_TW",
		"locale"		=> "zh_TW.utf-8");

	$languages['jp'] = Array(
		"id"			=> "ja",
		"name"			=> "日本語",
		"path"			=> "ja_JP",
		"locale"		=> "ja_JP.utf-8");

	$languages['ru'] = Array(
		"id"			=> "ru",
		"name"			=> "Pусский",
		"path"			=> "ru_RU",
		"locale"		=> "ru_RU.utf-8");


// ----------------------------------------------------------------------
// Load language strings
// ----------------------------------------------------------------------
	function load_language( $section ) 
	{ 
		global $rootdir, $lang, $languages;
;
		
		$lg = file( "$rootdir/langs/".$languages[$lang]['path'].".ini");
		$getstring = false;
		while (list($line,$value) = each($lg)) {
			if($value[0] == "[") {
				if (trim($value) == "[$section]") {

					$getstring = true; 
				} else {
					if ($getstring) break;	// End of section reached
					$getstring = false;
				}
			}
			if ($getstring && strpos(";#",$value[0]) === false && ($pos = strpos($value,"=")) != 0 && trim($value) != "") {
				$varname  = trim(substr($value,0,$pos));
				$varvalue = trim(substr($value,$pos+1));
				define("_".strtoupper($varname),$varvalue);
			}
		}
	}
	

// ----------------------------------------------------------------------
// INTERNATIONALIZATION
// ----------------------------------------------------------------------
	$lang = $ini_array['GENERAL']['lang'];
	if ( isset($_GET['lang']) ) $lang = $_GET['lang'];
	if ( !in_array( $lang, array( "en", "fr", "cn", "jp", "ru" ), true) ) $lang = 'en';
	if ( $lang <> $ini_array['GENERAL']['lang'] )						// Selected language has been changed
	{
		$ini_array['GENERAL']['lang'] = $lang;
		write_ini_file( INIFILE, $ini_array );
	}

	setlocale(LC_ALL, $languages[$lang]['locale']);						// Set locales according to selection
	load_language( "common" );											// Load translations from Common section

?>
