<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			functions.php
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.0
	- Description:  Functions shared 

*************************************************************************/


	defined( "BASEPATH" ) or die( "No direct script access allowed" );


// Return the color corresponding to the radiation level in µSv/h
	function Level_Color( $tmp_val )
	{
		$tmp_color = TH6_RGB;												// Extreme 		(Leave immediately)
		if ( $tmp_val < THRESHOLD_5 ) $tmp_color = TH5_RGB;					// Emergency 	(Leave immediately)
		if ( $tmp_val < THRESHOLD_4 ) $tmp_color = TH4_RGB;					// Critical 	(leave ASSAP)
		if ( $tmp_val < THRESHOLD_3 ) $tmp_color = TH3_RGB;					// Warning 		(potential danger)
		if ( $tmp_val < THRESHOLD_2 ) $tmp_color = TH2_RGB;					// Normal
		if ( $tmp_val < THRESHOLD_1 ) $tmp_color = TH1_RGB;					// Very low
		return $tmp_color;
	}

// Return the message or critical info
	function Message( $stt, $critical )
	{
		global $AGM_URL;

		return "
<!-- DISPLAY POPUP MESSAGE -->
	<script class='code' type='text/javascript'>
		
		// Automatically open popup on page load
		$( document ).ready( function () {
			$( '#popupMsg' ).popup( 'open' );
		});

		// Auto-close popup after 4 seconds
		setTimeout( function() {
			window.location = '" . ( $critical ? "$AGM_URL?page=home" : "javascript: history.go(-1);" ) . "';
		}, 4000 );

	</script>

	<div data-role='popup' data-dismissible='false' id='popupMsg' style='max-width:400px;'>
		<div data-role='header'><h1>" . ( $critical ? _MSG_ERROR : _MSG_INFO ) . "</h1></div>
		<div role='main' class='ui-content'><p>$stt</p></div>
	</div>
	";
	}


// Return the Radiation levels reminder string
	function Reminder_Message()
	{
		return "<u>" . _REMINDER_TITLE . "</u><br />
			<span style='color: " . TH1_RGB . "'>" .  sprintf( "<br /> < %-5.2f uSv/h - ", THRESHOLD_1 ) . _REMINDER_LVL1 . "</span>
			<span style='color: " . TH2_RGB . "'>" .  sprintf( "<br /> < %-5.2f uSv/h - ", THRESHOLD_2 ) . _REMINDER_LVL2 . "</span>
			<span style='color: " . TH3_RGB . "'>" .  sprintf( "<br /> < %-5.2f uSv/h - ", THRESHOLD_3 ) . _REMINDER_LVL3 . "</span>
			<span style='color: " . TH4_RGB . "'>" .  sprintf( "<br /> < %-5.2f uSv/h - ", THRESHOLD_4 ) . _REMINDER_LVL4 . "</span>
			<span style='color: " . TH5_RGB . "'>" .  sprintf( "<br /> < %-5.1f uSv/h - ", THRESHOLD_5 ) . _REMINDER_LVL5 . "</span>
			<span style='color: " . TH6_RGB . "'>" .  sprintf( "<br /> > %-5.1f uSv/h - ", THRESHOLD_5 ) . _REMINDER_LVL6 . "</span>";
	}

?>