<?php
/************************************************************************

	GEIGER-MULLER counter Manager developed by Ad'Novea®

	**********************************************
	- File:			agm.php (index.php)
	- Project:		A-GM Manager
	- Developer: 	Laurent (AdNovea®) - (c)2018
	- Date:			2018, july 14th
	- Version:		1.0
	- Description:  Geiger-Muller Counter data web displayed page
					This page has a short name (agm.php) rather than
					index.php due to the number of characters limitation
					with GMC-320 device regarding the URL length.

*************************************************************************/


// Set to 0 to disable, E_ALL, E_ERROR | E_WARNING | E_PARSE | E_NOTICE
	error_reporting( E_ALL );											
	ini_set( 'display_errors','On' );

	define( "BASEPATH", dirname(__FILE__) );
	opcache_reset();													// Force cache reset


// ----------------------------------------------------------------------
// Get configuration and read existing data
// ----------------------------------------------------------------------
// Base URL
	global $root, $rootdir;

	$root = str_replace( "/".basename( $_SERVER['PHP_SELF'] ), "", $_SERVER['PHP_SELF'] );
	define( "SYSURL", $_SERVER['SERVER_NAME'] . ":" . $_SERVER['SERVER_PORT'] . $root );
	$rootdir = str_replace( "/" . basename( __FILE__ ), "", __FILE__ );

	require_once( "$rootdir/inc/params.php" );
	require_once( "$rootdir/inc/read_ini.php" );

	date_default_timezone_set( $ini_array['GENERAL']['timezone'] );		// See http://php.net/manual/en/timezones.php 
	require_once( "$rootdir/inc/languages.php" );
	require_once( "$rootdir/inc/functions.php" );


// ----------------------------------------------------------------------
// Save data OR prepare HTML page
// ----------------------------------------------------------------------
	session_start();

	// Request from GM Counter to store data
	if ( isset( $_GET['CPM'] ) )
	{
		$data_file = $ini_array['GENERAL']['data_filename'];
		include( "$rootdir/inc/read_file.php" );
		include( "$rootdir/inc/save_data.php" );
	}

	// Request from user web browser
	else
	{	
		if ( isset( $_GET[ 'f' ] ) ) $data_file = "AGM_" . $_GET[ 'f' ] . ".csv" ;
		else $data_file = $ini_array['GENERAL']['data_filename'];
		require_once( "$rootdir/inc/read_file.php" );
		include( "$rootdir/inc/page.php" );
	}


?>