void setup() {
  pinMode(10,1); // set pin 10 as an output
  pinMode(12,1);
  Serial.begin(9600);
  while(!Serial){ // wait until the the serial communication is active
    // while the serial communication is not active: do nothing
  }
  Serial.println("Send 0 to turn off all LEDs, 1 to turn on the first LED, \n2 to turn on the second LED, and 3 to turn on both LEDs.");
}

void loop() {
  if(Serial.available() > 0){ // if there is any data in the buffer
    char serialValue = Serial.read(); // read the first byte from the buffer, and store it in a variable
    switch (serialValue){
      case '0':
        digitalWrite(12,0);
        digitalWrite(10,0);
        break;
      case '1':
        digitalWrite(12,1);
        digitalWrite(10,0);
        break;
      case '2':
        digitalWrite(12,0);
        digitalWrite(10,1);
        break;
      case '3':
        digitalWrite(12,1);
        digitalWrite(10,1);
        break;
      default:
        Serial.println("Please enter a value between 0 and 3 !");
        break;
    }
  }
}
