/*
  AnalogReadSerial
  Reads an analog input on pin 0, prints the result to the serial monitor.
  Graphical representation is available using serial plotter (Tools > Serial Plotter menu)
  Attach the center pin of a potentiometer to pin A0, and the outside pins to +5V and ground.

  This example code is in the public domain.
*/

const float R1 = 47000.0; // the resistor between the voltage source to measure and the analog input
const float R2 = 22000.0; // the resistor between the analog input and the ground
const float arduinoVoltage = 5.0; // the Arduino's operating voltage

const float ratio = (R1 + R2)/R2;
  // the setup routine runs once when you press reset:
void setup() {
  // initialize serial communication at 9600 bits per second:
  Serial.begin(9600);
  while(!Serial); // wait for the serial connection to be active
  Serial.print("Maximum voltage = ");
  Serial.print(ratio * 5); // the maximum input voltage is when the output voltage is 5v
  Serial.print("v\n____________________________\n");
}

// the loop routine runs over and over again forever:
void loop() {
  Serial.print(analogRead(A0) * 5.0 / 1023 * ratio); // convert the analog value to a voltage and print it
  Serial.println('v');
  delay(50); // slow down
}
