
 
/*  
 * TumbleGhost
 * This is a modified version of the original Flappy Bird Arduino code made by Dejan Nedelkovski, www.HowToMechatronics.com 
 * This program uses the UTFT and URTouch libraries
 *  made by Henning Karlsen. 
 *  You can find and download them at:
 *  www.RinkyDinkElectronics.com
 * Replaced UTouch with URTouch due to changed name of library
 * Created local redpacman3.c bitmap file to see what happens
 * Change text back for Steph to show friends - increase size of delete on verical drop
 * row 208 Was y-7 changed to y-12 to fix problem with residue from falling ghost
 * Added redraw of ground when the Ghost crashes into ground
 * V5 added moving eyes
 * V6 is final production version with no additional functionality for abasic game
 * V8 Copy of V6 final code however re-draw ground to cover the gap if near ground 
 * V10 Added Dim Circuit for this versioncontrolled by A7 if Dimmer circuit used
 */
 
#include <UTFT.h> 
#include <URTouch.h>
#include <EEPROM.h>

//==== Creating Objects
 UTFT    myGLCD(SSD1289,38,39,40,41); //Parameters should be adjusted to your Display/Schield model
 URTouch  myTouch( 6, 5, 4, 3, 2);
//==== Creating Objects
//UTFT myGLCD(ILI9341_16,38,39,40,41); //Parameters should be adjusted to your Display/Schield model
//URTouch  myTouch( 6, 5, 4, 3, 2);

//==== Defining Fonts
extern uint8_t SmallFont[];
extern uint8_t BigFont[];
extern uint8_t SevenSegNumFont[];

extern unsigned int redpacman3[0x41A]; // Ghost Bitmap Straight ahead
extern unsigned int redpacman3up[0x41A]; // Ghost Bitmap Straight ahead
extern unsigned int redpacman3down[0x41A]; // Ghost Bitmap Straight ahead
extern unsigned int bluepacman3[0x41A]; // Ghost Bitmap Blue

int x, y; // Variables for the coordinates where the display has been pressed

// Floppy ghost
int xP = 319;
int yP = 100;
int yB = 50;
int tempyB = 0; // Temp storage of yB to ensure correct redraw of bluepacman
int movingRate = 3;
int fallRateInt = 0;
float fallRate = 0;
int score = 0;
int lastSpeedUpScore = 0;
int highestScore;
boolean screenPressed = false;
boolean gameStarted = false;

// Display Dimmer Variables
int dimscreen = 255; // This variable is used to drive the screen brightness where 255 is max brightness
int LDR = 100; // LDR variable measured directly from Analog 7


void setup() {
  // Initiate display
  myGLCD.InitLCD();
  myGLCD.clrScr();
  myTouch.InitTouch();
  myTouch.setPrecision(PREC_MEDIUM);

// Setup Pin 9 of Arduino to LED A control brightness of the backlight. 
// This is done by firstly disconnecting Pin 19 of the TFT screen
// Followed by connecting D9 of Arduino to Pin 19 of TFT via a 47 ohm resistor
   pinMode(9, OUTPUT); // D9 used to PWM voltage to backlight on TFT screen
   analogWrite(9, 255); // Controls brightness 0 is Dark, Ambient room is approx 25 and 70 is direct sunlight

  
  highestScore = EEPROM.read(0); // Read the highest score from the EEPROM
  
  initiateGame(); // Initiate the game
}

void loop() {

// Set Screen Brightness
// Check the ambient light and adjust LED brightness to suit Ambient approx 500 dark is below 100
LDR = analogRead(A7);

/* Test value range of LDR
  myGLCD.setColor(237, 28, 36);
  myGLCD.setBackColor(0, 0, 0);
  myGLCD.printNumI(LDR,250,60,3);

if (LDR >=121){
    dimscreen = 255;
   } 
   
if (LDR <=120)   {  
    dimscreen = 20;
   }    
*/

dimscreen = (LDR/4)+5;

if (dimscreen >= 255){
  dimscreen = 255;
  }
//analogWrite(9, dimscreen); // Controls brightness 0 is Dark, Ambient room is approx 25 and 70 is direct sunlight 
analogWrite(9, 255); // Controls brightness 0 is Dark, Ambient room is approx 25 and 70 is direct sunlight 



  xP=xP-movingRate; // xP - x coordinate of the pilars; range: 319 - (-51)   
    drawPilars(xP, yP); // Draws the pillars 
    
    // yB - y coordinate of the ghost which depends on value of the fallingRate variable
    tempyB = yB; // Temp storage of yB to ensure correct redraw of bluepacman
    yB+=fallRateInt; 
    fallRate=fallRate+0.4; // Each interation the fall rate increase so that we can the effect of acceleration/ gravity
    fallRateInt= int(fallRate);
    
    // Checks for collision
    if(yB>=180 || yB<=0){ // top and bottom

    if(yB<=0) {
 
     // Draws blue rectangles below the Ghost remove trail
     myGLCD.setColor(114, 198, 206);
     myGLCD.fillRoundRect(50,yB+30,85,yB+52);  
     }
    
    // Draw Blue unhappy Ghost
    myGLCD.drawBitmap (50, tempyB, 35, 30, bluepacman3); // Blue Ghost when crashed
    drawPilars(xP, yP); // Draws the pillars       
    gameOver();
    }
    if((xP<=85) && (xP>=5) && (yB<=yP-2)){ // upper pillar
  
        // Draw Blue unhappy Ghost
      myGLCD.drawBitmap (50, tempyB, 35, 30, bluepacman3); // Blue Ghost
      drawPilars(xP, yP); // Draws the pillars     
      gameOver();
    }
    if((xP<=85) && (xP>=5) && (yB>=yP+60)){ // lower pillar
 
       // Draw Blue unhappy Ghost
      myGLCD.drawBitmap (50, tempyB, 35, 30, bluepacman3); // Blue Ghost
      drawPilars(xP, yP); // Draws the pillars 
      gameOver();
    }
    
    // Draws the ghost
    drawghost(yB);

    // After the pillar has passed through the screen
    if (xP<=-51){
      xP=319; // Resets xP to 319
      yP = rand() % 100+20; // Random number for the pillars height
      score++; // Increase score by one
    }
    //==== Controlling the ghost
    if (myTouch.dataAvailable()&& !screenPressed) {
       fallRate=-6; // Setting the fallRate negative will make the ghost jump
       screenPressed = true;
    }
    // Doesn't allow holding the screen / you must tap it
    else if ( !myTouch.dataAvailable() && screenPressed){
      screenPressed = false;
    }
    
    // After each five points, increases the moving rate of the pillars
    if ((score - lastSpeedUpScore) == 5) {
      lastSpeedUpScore = score;
      movingRate++;
    }
}
// ===== initiateGame - Custom Function
void initiateGame() {
  myGLCD.clrScr();
  // Blue background
  myGLCD.setColor(114, 198, 206);
  myGLCD.fillRect(0,0,319,239);
  // Ground
  myGLCD.setColor(221,216,148);
  myGLCD.fillRect(0, 215, 319, 239);
  myGLCD.setColor(47,175,68);
  myGLCD.fillRect(0, 205, 319, 214);
  // Text
  myGLCD.setColor(0, 0, 0);
  myGLCD.setBackColor(221, 216, 148);
  myGLCD.setFont(BigFont);
  myGLCD.print("Score:",5,220);
 // myGLCD.print("Floppy Ghost", 120, 220); 
  myGLCD.setFont(SmallFont);
 // myGLCD.print("Tumble Ghost", 140, 220); 
  myGLCD.setColor(0, 0, 0);
  myGLCD.setBackColor(114, 198, 206);
  myGLCD.print("High Score: ",5,5);
  myGLCD.printNumI(highestScore, 120, 6);
  myGLCD.print(">RESET<",255,5);
  myGLCD.drawLine(0,23,319,23);
  myGLCD.setFont(BigFont);
  myGLCD.print("TUMBLE GHOST",CENTER,100);
  myGLCD.setFont(SmallFont);
  myGLCD.print("Tap to start",CENTER,120);
  
  drawghost(yB); // Draws the ghost
  
  // Wait until we tap the screen
  while (!gameStarted) {
    if (myTouch.dataAvailable()) {
    myTouch.read();
    x=myTouch.getX();
    y=myTouch.getY();        
    // Reset higest score
    if ((x>=250) && (x<=319) &&(y>=0) && (y<=28)) {
    highestScore = 0;
    myGLCD.setColor(114, 198, 206);
    myGLCD.fillRect(120, 0, 150, 22);
    myGLCD.setColor(0, 0, 0);
    myGLCD.printNumI(highestScore, 120, 5);
    } 
    if ((x>=0) && (x<=319) &&(y>=30) && (y<=239)) {
    gameStarted = true;
    myGLCD.setColor(114, 198, 206);
    myGLCD.fillRect(0, 0, 319, 32);
    }   
  }
  }
  // Clears the text "TAP TO START" before the game start
  myGLCD.setColor(114, 198, 206);
  myGLCD.fillRect(60, 100, 260, 140); // myGLCD.fillRect(85, 100, 235, 116)
  
}
// ===== drawPlillars - Custom Function
void drawPilars(int x, int y) {
    if (x>=270){
      myGLCD.setColor(0, 200, 20);
      myGLCD.fillRect(318, 0, x, y-1);
      myGLCD.setColor(0, 0, 0);
      myGLCD.drawRect(319, 0, x-1, y);

      myGLCD.setColor(0, 200, 20);
      myGLCD.fillRect(318, y+81, x, 203);
      myGLCD.setColor(0, 0, 0);
      myGLCD.drawRect(319, y+80, x-1, 204); 
    }
    else if( x<=268) {
      // Draws blue rectangle right of the pillar
      myGLCD.setColor(114, 198, 206);
      myGLCD.fillRect(x+51, 0, x+60, y);
      // Draws the pillar
      myGLCD.setColor(0, 200, 20);
      myGLCD.fillRect(x+49, 1, x+1, y-1);
      // Draws the black frame of the pillar
      myGLCD.setColor(0, 0, 0);
      myGLCD.drawRect(x+50, 0, x, y);
      // Draws the blue rectangle left of the pillar
      myGLCD.setColor(114, 198, 206);
      myGLCD.fillRect(x-1, 0, x-3, y);

      // The bottom pillar
      myGLCD.setColor(114, 198, 206);
      myGLCD.fillRect(x+51, y+80, x+60, 204);
      myGLCD.setColor(0, 200, 20);
      myGLCD.fillRect(x+49, y+81, x+1, 203);
      myGLCD.setColor(0, 0, 0);
      myGLCD.drawRect(x+50, y+80, x, 204);
      myGLCD.setColor(114, 198, 206);
      myGLCD.fillRect(x-1, y+80, x-3, 204);
  }
  // Draws the score
  myGLCD.setColor(0, 0, 0);
  myGLCD.setBackColor(221, 216, 148);
  myGLCD.setFont(BigFont);
  myGLCD.printNumI(score, 100, 220);
}

//====== drawghost() - Custom Function
void drawghost(int y) {
  // Draws the ghost - bitmap

  
  
 if (fallRate<-2){
    myGLCD.drawBitmap (50, y, 35, 30, redpacman3up); // If fallrate -ve eyesdown
 } else if(fallRate<2){
    myGLCD.drawBitmap (50, y, 35, 30, redpacman3); // If fallrate neutral eyesforward
 } else {    
  myGLCD.drawBitmap (50, y, 35, 30, redpacman3down); // If fallrate -ve eyesup
 }
  // Draws blue rectangles above and below the ghostghost in order to clear its previus state
  myGLCD.setColor(114, 198, 206);
  myGLCD.fillRoundRect(50,y,85,y-12); // row 208 Was y-7 changed to y-12 to fix problem with residue from falling ghost
  myGLCD.fillRoundRect(50,y+30,85,y+36); //row208 was y+36 changed to 

  // Re-draw Ground to cover any gap
  myGLCD.setColor(47,175,68);
  myGLCD.fillRect(25, 205, 100, 214);


}
//======== gameOver() - Custom Function
void gameOver() {


  // Re-draw Ground
  myGLCD.setColor(47,175,68);
  myGLCD.fillRect(0, 205, 319, 214);
  delay(3000); // 1 second
  // Clears the screen and prints the text
  myGLCD.clrScr();
  myGLCD.setColor(114, 198, 206);
  myGLCD.setBackColor(0, 0, 0);// was 000
  myGLCD.setFont(BigFont);
  myGLCD.print("GAME OVER", CENTER, 40);
  myGLCD.print("Score:", 100, 80);
  myGLCD.printNumI(score,200, 80);
  myGLCD.print("Restarting...", CENTER, 120);
  myGLCD.setFont(SevenSegNumFont);
  myGLCD.printNumI(2,CENTER, 150);
  delay(1000);
  myGLCD.printNumI(1,CENTER, 150);
  delay(1000);
  
  // Writes the highest score in the EEPROM
  if (score > highestScore) {
    highestScore = score;
    EEPROM.write(0,highestScore);
  }
  // Resets the variables to start position values
  xP=319;
  yB=50;
  fallRate=0;
  score = 0;
  lastSpeedUpScore = 0;
  movingRate = 3;  
  gameStarted = false;
  // Restart game
  initiateGame();
}
